/*
 * Decompiled with CFR 0.152.
 */
package com.swtxml.ide;

import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Transform;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Sash;

public class ResizableComposite
extends Composite {
    private static final int HORIZONTAL_SASH_HEIGHT = 30;
    private static final int VERTICAL_SASH_WIDTH = 30;
    private Composite innerComposite;
    private GridData innerCompositeLayoutData;

    public ResizableComposite(Composite parent) {
        super(parent, 0);
        GridLayoutFactory.fillDefaults().numColumns(2).spacing(0, 0).applyTo((Composite)this);
        this.setBackground(Display.getDefault().getSystemColor(1));
        this.innerComposite = new Composite((Composite)this, 0);
        this.innerCompositeLayoutData = new GridData(100, 100);
        this.innerComposite.setLayoutData((Object)this.innerCompositeLayoutData);
        Sash verticalSash = new Sash((Composite)this, 66048);
        GridDataFactory.fillDefaults().hint(30, 0).applyTo((Control)verticalSash);
        verticalSash.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ResizableComposite.this.innerCompositeLayoutData.widthHint = e.x;
                ResizableComposite.this.checkLayout();
            }
        });
        verticalSash.addPaintListener(this.createVerticalRulerPainter());
        verticalSash.setBackground(Display.getDefault().getSystemColor(1));
        verticalSash.setForeground(Display.getDefault().getSystemColor(9));
        Sash horizontalSash = new Sash((Composite)this, 65536);
        GridDataFactory.fillDefaults().span(2, 1).hint(0, 30).applyTo((Control)horizontalSash);
        horizontalSash.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ResizableComposite.this.innerCompositeLayoutData.heightHint = e.y;
                ResizableComposite.this.checkLayout();
            }
        });
        horizontalSash.setBackground(Display.getDefault().getSystemColor(1));
        horizontalSash.setForeground(Display.getDefault().getSystemColor(9));
        horizontalSash.addPaintListener(this.createHorizontalRulerPainter());
        this.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                ResizableComposite.this.checkLayout();
            }
        });
    }

    protected void checkLayout() {
        Control[] children;
        this.innerCompositeLayoutData.widthHint = Math.min(this.innerCompositeLayoutData.widthHint, this.getBounds().width - 30);
        this.innerCompositeLayoutData.heightHint = Math.min(this.innerCompositeLayoutData.heightHint, this.getBounds().height - 30);
        this.layout();
        Control[] controlArray = children = this.getChildren();
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            Control control = controlArray[n2];
            control.redraw();
            ++n2;
        }
    }

    protected void resetSize() {
        this.getParent().layout();
        Point size = this.innerComposite.computeSize(-1, -1);
        this.innerCompositeLayoutData.widthHint = size.x;
        this.innerCompositeLayoutData.heightHint = size.y;
        this.checkLayout();
    }

    private PaintListener createHorizontalRulerPainter() {
        return new PaintListener(){

            public void paintControl(PaintEvent e) {
                int w = ResizableComposite.this.innerComposite.getBounds().width;
                if (w == 0) {
                    return;
                }
                int xStart = 0;
                int yStart = 15;
                int oldAntialias = e.gc.getAntialias();
                e.gc.setAntialias(1);
                e.gc.drawLine(xStart, yStart, xStart + w, yStart);
                e.gc.drawLine(xStart, yStart - 5, xStart, yStart + 5);
                e.gc.drawLine(xStart, yStart, xStart + 8, yStart + 4);
                e.gc.drawLine(xStart, yStart, xStart + 8, yStart - 4);
                e.gc.drawLine(xStart + w, yStart - 5, xStart + w, yStart + 5);
                e.gc.drawLine(xStart + w, yStart, xStart + w - 8, yStart + 4);
                e.gc.drawLine(xStart + w, yStart, xStart + w - 8, yStart - 4);
                e.gc.setFont(Display.getDefault().getSystemFont());
                String text = " " + w + " px ";
                e.gc.drawString(text, xStart + w / 2 - e.gc.stringExtent((String)text).x / 2, 8);
                e.gc.setAntialias(oldAntialias);
            }
        };
    }

    private PaintListener createVerticalRulerPainter() {
        return new PaintListener(){

            public void paintControl(PaintEvent e) {
                int h = ResizableComposite.this.innerComposite.getBounds().height;
                if (h == 0) {
                    return;
                }
                int xStart = 15;
                int yStart = 0;
                int oldAntialias = e.gc.getAntialias();
                e.gc.setAntialias(1);
                e.gc.drawLine(xStart, yStart, xStart, yStart + h - 1);
                e.gc.drawLine(xStart - 5, yStart, xStart + 5, yStart);
                e.gc.drawLine(xStart, yStart, xStart + 4, yStart + 8);
                e.gc.drawLine(xStart, yStart, xStart - 4, yStart + 8);
                e.gc.drawLine(xStart - 5, yStart + h - 1, xStart + 5, yStart + h - 1);
                e.gc.drawLine(xStart, yStart + h - 1, xStart + 4, yStart + h - 9);
                e.gc.drawLine(xStart, yStart + h - 1, xStart - 4, yStart + h - 9);
                String text = " " + h + " px ";
                e.gc.setFont(Display.getDefault().getSystemFont());
                Transform transform = new Transform(e.gc.getDevice());
                transform.translate(7.0f, (float)(yStart + h / 2 + e.gc.stringExtent((String)text).x / 2));
                transform.rotate(-90.0f);
                e.gc.setTransform(transform);
                e.gc.drawText(text, 0, 0);
                e.gc.setTransform(null);
                transform.dispose();
                e.gc.setAntialias(oldAntialias);
            }
        };
    }

    public Composite getResizeableComposite() {
        return this.innerComposite;
    }
}

