/*
 * Decompiled with CFR 0.152.
 */
package com.swtxml.ide;

import com.swtxml.adapter.IAdaptable;
import com.swtxml.definition.IAttributeDefinition;
import com.swtxml.definition.INamespaceDefinition;
import com.swtxml.definition.ITagDefinition;
import com.swtxml.definition.ITagScope;
import com.swtxml.extensions.ExtensionsNamespaceResolver;
import com.swtxml.ide.DocumentNamespaceBrowser;
import com.swtxml.swt.types.LayoutType;
import com.swtxml.util.context.Context;
import com.swtxml.util.parser.Strictness;
import com.swtxml.util.proposals.Match;
import com.swtxml.util.types.IContentAssistable;
import com.swtxml.util.types.IType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.jface.text.contentassist.CompletionProposal;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegionList;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.eclipse.wst.xml.ui.internal.contentassist.ContentAssistRequest;
import org.eclipse.wst.xml.ui.internal.contentassist.XMLContentAssistProcessor;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class SwtXmlContentAssistProcessor
extends XMLContentAssistProcessor {
    protected void addTagNameProposals(ContentAssistRequest contentAssistRequest, int childPosition) {
        Node parentNode;
        Match match = this.createMatch(contentAssistRequest);
        DocumentNamespaceBrowser namespaces = this.getNamespaceBrowser(contentAssistRequest);
        INamespaceDefinition parentNamespace = namespaces.getByURI((parentNode = contentAssistRequest.getNode().getParentNode()).getNamespaceURI());
        if (parentNamespace == null) {
            return;
        }
        ITagDefinition parentTag = parentNamespace.getTag(parentNode.getLocalName());
        if (parentTag == null) {
            return;
        }
        ArrayList<String> filteredTags = new ArrayList<String>();
        for (INamespaceDefinition namespace : namespaces.getAllDefinitions()) {
            for (String tagname : namespace.getTagNames()) {
                boolean allowedInContext;
                ITagDefinition tag = namespace.getTag(tagname);
                boolean bl = allowedInContext = !(tag instanceof ITagScope) || ((ITagScope)tag).isAllowedIn(parentTag);
                if (!allowedInContext) continue;
                filteredTags.add(String.valueOf(namespaces.getPrefix(namespace)) + tag.getName());
            }
        }
        if (contentAssistRequest.getNode() instanceof Text) {
            match = match.insertAroundMatch("", "/>");
        }
        this.addProposals(contentAssistRequest, match.propose(filteredTags));
        super.addTagNameProposals(contentAssistRequest, childPosition);
    }

    private DocumentNamespaceBrowser getNamespaceBrowser(ContentAssistRequest contentAssistRequest) {
        return new DocumentNamespaceBrowser(contentAssistRequest.getNode().getOwnerDocument());
    }

    protected void addAttributeNameProposals(ContentAssistRequest contentAssistRequest) {
        DocumentNamespaceBrowser namespaces = this.getNamespaceBrowser(contentAssistRequest);
        Node node = contentAssistRequest.getNode();
        INamespaceDefinition namespace = this.getNamespace(node);
        if (namespace == null) {
            return;
        }
        ITagDefinition tag = namespace.getTag(node.getLocalName());
        if (tag == null) {
            return;
        }
        Match match = this.createMatch(contentAssistRequest);
        match = match.insertAroundMatch("", "=\"\"");
        List proposals = match.propose((Collection)tag.getAttributeNames());
        ArrayList<String> foreignAttributeNames = new ArrayList<String>();
        for (INamespaceDefinition ns : namespaces.getAllDefinitions()) {
            for (String foreignAttributeName : ns.getForeignAttributeNames()) {
                IAttributeDefinition foreignAttribute = ns.getForeignAttribute(foreignAttributeName);
                if (foreignAttribute instanceof ITagScope && !((ITagScope)foreignAttribute).isAllowedIn(tag)) continue;
                foreignAttributeNames.add(String.valueOf(namespaces.getPrefix(ns)) + foreignAttribute.getName());
            }
        }
        proposals.addAll(match.propose(foreignAttributeNames));
        for (Match proposal : proposals) {
            proposal.moveCursor(2);
        }
        this.addProposals(contentAssistRequest, proposals);
    }

    private INamespaceDefinition getNamespace(Node node) {
        return new ExtensionsNamespaceResolver().resolveNamespace(node.getNamespaceURI());
    }

    protected void addAttributeValueProposals(final ContentAssistRequest contentAssistRequest) {
        IType type;
        IDOMNode node = (IDOMNode)contentAssistRequest.getNode();
        INamespaceDefinition namespace = this.getNamespace((Node)node);
        if (namespace == null) {
            return;
        }
        ITagDefinition tag = namespace.getTag(node.getLocalName());
        if (tag == null) {
            return;
        }
        IStructuredDocumentRegion open = node.getFirstStructuredDocumentRegion();
        ITextRegionList openRegions = open.getRegions();
        int i = openRegions.indexOf(contentAssistRequest.getRegion());
        if (i < 0) {
            return;
        }
        ITextRegion nameRegion = null;
        while (i >= 0) {
            if ((nameRegion = openRegions.get(i--)).getType() == "XML_TAG_ATTRIBUTE_NAME") break;
        }
        if (nameRegion == null) {
            return;
        }
        String attributeName = open.getText(nameRegion);
        IAttributeDefinition attribute = tag.getAttribute(attributeName);
        if (attribute == null) {
            return;
        }
        if ("layoutData".equals(attributeName)) {
            Context.addAdapter((IAdaptable)new IAdaptable(){

                public <T> T adaptTo(Class<T> adapterClass) {
                    Node layoutNode;
                    if (adapterClass == Layout.class && (layoutNode = contentAssistRequest.getNode().getParentNode().getAttributes().getNamedItem("layout")) != null) {
                        return (T)new LayoutType().convert(layoutNode.getNodeValue(), Strictness.NICE);
                    }
                    return null;
                }
            });
        }
        if ((type = attribute.getType()) instanceof IContentAssistable) {
            Match match = this.createMatch(contentAssistRequest).handleQuotes();
            this.addProposals(contentAssistRequest, ((IContentAssistable)type).getProposals(match));
        }
        Context.clear();
    }

    private void addProposals(ContentAssistRequest contentAssistRequest, List<Match> proposals) {
        for (Match proposal : proposals) {
            CompletionProposal newProposal = new CompletionProposal(proposal.getReplacementText(), contentAssistRequest.getReplacementBeginPosition(), contentAssistRequest.getReplacementLength(), proposal.getReplacementCursorPos(), null, proposal.getText(), null, null);
            contentAssistRequest.addProposal((ICompletionProposal)newProposal);
        }
    }

    private Match createMatch(ContentAssistRequest contentAssistRequest) {
        return new Match(contentAssistRequest.getText(), contentAssistRequest.getMatchString().length());
    }
}

