/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.cdt.builders;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.cdt.codan.core.CodanRuntime;
import org.eclipse.cdt.codan.core.model.CheckerLaunchMode;
import org.eclipse.cdt.codan.core.model.ICodanBuilder;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.ILanguage;
import org.eclipse.cdt.core.model.LanguageManager;
import org.eclipse.cdt.core.settings.model.CSourceEntry;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.core.settings.model.ICProjectDescription;
import org.eclipse.cdt.core.settings.model.ICProjectDescriptionManager;
import org.eclipse.cdt.core.settings.model.ICSourceEntry;
import org.eclipse.core.internal.resources.LinkDescription;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.debug.core.DebugPlugin;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;
import ro.amiq.dvt.DVTPlugin;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.buildconfig.BuildConfigManager;
import ro.amiq.dvt.buildconfig.CdtBuildKind;
import ro.amiq.dvt.buildconfig.CdtFileTypeAutoMapKind;
import ro.amiq.dvt.buildconfig.Cflags;
import ro.amiq.dvt.buildconfig.IBuildConfigParserConstants;
import ro.amiq.dvt.buildconfig.SkipCompileFilter;
import ro.amiq.dvt.builders.DVTAutoLinkManager;
import ro.amiq.dvt.builders.DVTBuildConsoleRegistry;
import ro.amiq.dvt.cdt.builders.CdtFileTypeMap;
import ro.amiq.dvt.cdt.builders.ReadelfParser;
import ro.amiq.dvt.cdt.model.persistence.Persistence;
import ro.amiq.dvt.cdt.model.reflection.RfManager;
import ro.amiq.dvt.cdt.model.reflection.RfProject;
import ro.amiq.dvt.cdt.nature.CPPNatureContributor;
import ro.amiq.dvt.cdt.utils.CDTUtils;
import ro.amiq.dvt.core.DVTNature;
import ro.amiq.dvt.model.AbstractBuildContributor;
import ro.amiq.dvt.model.FileCompileInfo;
import ro.amiq.dvt.model.problems.DVTProblemCategories;
import ro.amiq.dvt.model.reflection.IRfSingleLangProject;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.nature.INatureContributor;
import ro.amiq.dvt.nature.NatureContributors;
import ro.amiq.dvt.resources.properties.PropertiesManager;
import ro.amiq.dvt.resources.properties.PropertyTypes;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.test.TestHelper;
import ro.amiq.dvt.ui.decorators.DVTAbstractDecorator;
import ro.amiq.dvt.utils.DVTFileUtils;
import ro.amiq.dvt.utils.DVTProcessRunner;
import ro.amiq.dvt.utils.DVTProfilingUtils;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.dvt.utils.GCCUtils;

public class CDTBuildContributor
extends AbstractBuildContributor {
    public static final String ID = "ro.amiq.dvt.cdt.builders.CDTBuildContributor";
    private static final String CDT_BUILDER_CALLER_NAME = "C/C++ Builder";
    private final Set<ParserPath> fResources2CreateSet = new LinkedHashSet<ParserPath>();
    private final Set<IPath> fFilesToExcludeFromCDTBuild = new LinkedHashSet<IPath>();
    private List<String> cTopFilesList = null;
    private String gccStdErr = null;
    private String gccStdOut = null;
    private final Set<FileCompileInfo> fDeltaChanged = new LinkedHashSet<FileCompileInfo>();
    private final Set<IFile> fDeltaRemoved = new LinkedHashSet<IFile>();
    private SubProgressMonitor fIncrMonitor;
    private boolean fIncrMonitorBegin;
    private boolean fIncrMonitorDone;
    private ICodanBuilder fCodanBuilder;

    public CDTBuildContributor() {
        CodanRuntime codanRuntime = CodanRuntime.getInstance();
        this.fCodanBuilder = codanRuntime == null ? null : codanRuntime.getBuilder();
    }

    public IProject[] build(int kind, Map args, IProgressMonitor monitor, Map<LanguageKind, Set<FileCompileInfo>> changedFiles) throws CoreException {
        IProject project;
        block9: {
            block8: {
                block7: {
                    project = this.getProject();
                    if (args == null || !args.containsKey("justClean") || !args.get("justClean").equals("true")) break block7;
                    this.clean(monitor);
                    return null;
                }
                if (this.isEnabled(project)) break block8;
                return null;
            }
            if (DVTPlugin.getDefault().collect().c(project, "F636F7265")) break block9;
            return null;
        }
        try {
            if (kind == 6 || (kind == 10 || kind == 9) && this.getDelta(this.getProject()) == null) {
                this.fullBuild(monitor, project);
            } else {
                this.incrementalBuild(monitor);
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        return null;
    }

    private void fullBuild(IProgressMonitor monitor, IProject project) throws CoreException {
        RfProject rfProject;
        this.updateDeprecatedProject(monitor);
        this.updateCDTLanguageProviders(project);
        this.fResources2CreateSet.clear();
        this.fFilesToExcludeFromCDTBuild.clear();
        this.collectIncludedFiles(project, monitor);
        this.updateCDTFileTypes(project);
        this.createAutoLinkedResources(project, monitor);
        this.excludeFilesFromCDTBuildAndIndex(project, monitor);
        Persistence persistence = RfManager.getInstance().getPersistence(this.getProject());
        if (persistence != null) {
            persistence.setDirty();
        }
        DVTBuildConsoleRegistry.getConsole((IProject)project).printSection("Running C/C++ Indexer");
        CDTUtils.waitForCDTIndexerIdle();
        CCorePlugin.getIndexManager().reindex(CoreModel.getDefault().getCModel().getCProject(project.getName()));
        CDTUtils.waitForCDTIndexerIdle();
        if (this.shouldRunCodan(CdtBuildKind.FULL)) {
            DVTBuildConsoleRegistry.getConsole((IProject)project).printSection("Running C/C++ Code Analysis");
            this.fCodanBuilder.processResource((IResource)project, monitor, CheckerLaunchMode.RUN_ON_FULL_BUILD);
        }
        if ((rfProject = RfManager.getInstance().getRfProject(this.getProject())) != null) {
            rfProject.build(this.cTopFilesList, this.gccStdErr, this.gccStdOut);
        }
        this.cTopFilesList = null;
        this.gccStdErr = null;
        this.gccStdOut = null;
    }

    private boolean shouldRunCodan(CdtBuildKind buildKind) {
        return BuildConfigManager.getRunCodan((IProject)this.getProject()).contains(buildKind);
    }

    private void updateCDTFileTypes(IProject project) {
        CdtFileTypeMap cdtFileTypeMap = new CdtFileTypeMap();
        this.addFileTypesFromCompiledFiles(cdtFileTypeMap);
        Map userProvidedCdtFileTypeMap = BuildConfigManager.getCdtFileTypeMap((IProject)project);
        if (userProvidedCdtFileTypeMap != null) {
            userProvidedCdtFileTypeMap.forEach((nameOrExt, cdtFileType) -> cdtFileTypeMap.put((String)nameOrExt, (IBuildConfigParserConstants.CdtFileType)cdtFileType));
        }
        if (cdtFileTypeMap.isEmpty()) {
            return;
        }
        try {
            Preferences contentTypesNode = Platform.getPreferencesService().getRootNode().node("project").node(project.getName()).node("org.eclipse.core.runtime").node("content-types");
            contentTypesNode.putBoolean("enabled", true);
            IBuildConfigParserConstants.CdtFileType[] cdtFileTypeArray = IBuildConfigParserConstants.CdtFileType.values();
            int n = cdtFileTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                IBuildConfigParserConstants.CdtFileType ft = cdtFileTypeArray[n2];
                Preferences headerContentTypeNode = contentTypesNode.node(ft.PREF_KEY);
                Set<String> names = cdtFileTypeMap.computeNames(ft);
                if (names != null && !names.isEmpty()) {
                    headerContentTypeNode.put("file-names", String.join((CharSequence)",", names));
                } else {
                    headerContentTypeNode.remove("file-names");
                }
                Set<String> extensions = cdtFileTypeMap.computeExtensions(ft);
                if (extensions != null && !extensions.isEmpty()) {
                    headerContentTypeNode.put("file-extensions", String.join((CharSequence)",", extensions));
                } else {
                    headerContentTypeNode.remove("file-extensions");
                }
                ++n2;
            }
            contentTypesNode.flush();
        }
        catch (BackingStoreException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    private void addFileTypesFromCompiledFiles(CdtFileTypeMap cdtFileTypeMap) {
        IProject project = this.getProject();
        CdtFileTypeAutoMapKind autoMapKind = BuildConfigManager.getCdtFileTypeAutoMapKind((IProject)project);
        if (autoMapKind == CdtFileTypeAutoMapKind.DISABLE) {
            return;
        }
        List cTopFiles = Cflags.getCTopFiles((IProject)project);
        HashSet cTopFilesSet = cTopFiles == null ? Collections.emptySet() : new HashSet(cTopFiles);
        List systemIncdirs = GCCUtils.getCSystemHeadersIncdirs((IProject)project);
        for (ParserPath path : this.fResources2CreateSet) {
            if (autoMapKind == CdtFileTypeAutoMapKind.SYSTEM_HEADERS && !this.isSystemHeader(systemIncdirs, path)) continue;
            IBuildConfigParserConstants.CdtFileType type = cTopFilesSet.contains(path.path) ? IBuildConfigParserConstants.CdtFileType.CPP_SOURCE : IBuildConfigParserConstants.CdtFileType.CPP_HEADER;
            cdtFileTypeMap.put(new File(path.path).getName(), type);
        }
    }

    private boolean isSystemHeader(List<String> systemIncdirs, ParserPath path) {
        for (String incdir : systemIncdirs) {
            if (!path.path.startsWith(incdir)) continue;
            return true;
        }
        return false;
    }

    private void excludeFilesFromCDTBuildAndIndex(IProject project, IProgressMonitor monitor) throws CoreException {
        ICProjectDescription cProjectDescription = CoreModel.getDefault().getProjectDescription(project, true);
        if (cProjectDescription == null) {
            return;
        }
        ICConfigurationDescription[] cConfigDescriptions = cProjectDescription.getConfigurations();
        if (cConfigDescriptions == null) {
            return;
        }
        final SkipCompileFilter skipCompileFilter = BuildConfigManager.getSkipCompileFilter((IProject)project);
        int sourceEntryFlags = 24;
        ICConfigurationDescription[] iCConfigurationDescriptionArray = cConfigDescriptions;
        int n = cConfigDescriptions.length;
        int n2 = 0;
        while (n2 < n) {
            final ICConfigurationDescription cConfigDescription = iCConfigurationDescriptionArray[n2];
            try {
                HashSet<CSourceEntry> sourceEntries = new HashSet<CSourceEntry>();
                project.accept(new IResourceVisitor(){

                    public boolean visit(IResource resource) throws CoreException {
                        boolean importedFromTopFile;
                        boolean indexedByCDT;
                        if (resource instanceof IContainer) {
                            return true;
                        }
                        if (!(resource instanceof IFile)) {
                            return false;
                        }
                        boolean bl = indexedByCDT = LanguageManager.getInstance().getLanguageForFile((IFile)resource, cConfigDescription) != null;
                        if (!indexedByCDT) {
                            return false;
                        }
                        boolean bl2 = importedFromTopFile = PropertiesManager.getSessionProperty((IResource)resource, (String)PropertyTypes.QN_IMPORTED_FILE) != null;
                        if (!importedFromTopFile || skipCompileFilter.shouldSkip(DVTFileUtils.getInstance().resource2parser(resource), true)) {
                            CDTBuildContributor.this.fFilesToExcludeFromCDTBuild.add(resource.getProjectRelativePath());
                        }
                        return true;
                    }
                });
                sourceEntries.add(new CSourceEntry("", this.fFilesToExcludeFromCDTBuild.toArray(new IPath[this.fFilesToExcludeFromCDTBuild.size()]), sourceEntryFlags));
                cConfigDescription.setSourceEntries(sourceEntries.toArray(new ICSourceEntry[sourceEntries.size()]));
                CoreModel.getDefault().setProjectDescription(project, cProjectDescription, true, monitor);
            }
            catch (Exception e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
            }
            ++n2;
        }
    }

    private void collectIncludedFiles(IProject project, IProgressMonitor monitor) {
        List cTopFiles = Cflags.getCTopFiles((IProject)project);
        if (cTopFiles == null || cTopFiles.isEmpty()) {
            DVTBuildConsoleRegistry.getConsole((IProject)project).print("No C/C++ top files provided.");
        } else {
            for (String cTopFile : cTopFiles) {
                this.fResources2CreateSet.add(new ParserPath(cTopFile));
            }
            DVTBuildConsoleRegistry.getConsole((IProject)project).print("Scan included C/C++ files using GCC...");
            Set<String> inlcudedCFiles = this.collectIncludedFilesFromTops(project, cTopFiles);
            if (inlcudedCFiles != null && !inlcudedCFiles.isEmpty()) {
                for (String includedFile : inlcudedCFiles) {
                    this.fResources2CreateSet.add(new ParserPath(includedFile));
                }
            }
        }
        Set soTopFiles = BuildConfigManager.getSoTopFiles((IProject)project);
        if (soTopFiles == null || soTopFiles.isEmpty()) {
            return;
        }
        DVTBuildConsoleRegistry.getConsole((IProject)project).print("Scan C/C++ files from shared objects using readelf...");
        Set<String> cFilesFromSo = this.collectIncludedFilesFromSOs(monitor, project, soTopFiles);
        if (cFilesFromSo != null && !cFilesFromSo.isEmpty()) {
            for (String cFileFromSo : cFilesFromSo) {
                this.fResources2CreateSet.add(new ParserPath(cFileFromSo));
            }
        }
    }

    private Set<String> collectIncludedFilesFromSOs(IProgressMonitor monitor, final IProject project, Set<String> soTopFiles) {
        String readelfPath = GCCUtils.getBinaryPath((String)"readelf");
        if (readelfPath == null) {
            this.reportError(project, "readelf executable not found!");
            return null;
        }
        ArrayList<String> readelfArgs = new ArrayList<String>();
        readelfArgs.add(readelfPath);
        readelfArgs.add("--debug-dump=line");
        readelfArgs.add("--debug-dump=info");
        ArrayList<String> tempSoTopFiles = new ArrayList<String>();
        for (String soTopFile : soTopFiles) {
            tempSoTopFiles.add(soTopFile);
        }
        Collections.sort(tempSoTopFiles);
        for (String soTopFile : tempSoTopFiles) {
            readelfArgs.add(soTopFile);
        }
        DVTBuildConsoleRegistry.getConsole((IProject)project).print(DVTStringUtil.join(readelfArgs, (String)" \\\n    "));
        DVTProcessRunner readelfProc = new DVTProcessRunner(readelfArgs);
        int readelfTimeout = BuildConfigManager.getReadelfTimeout((IProject)project);
        try {
            readelfProc.run(null, (long)readelfTimeout * 1000L);
        }
        catch (DVTProcessRunner.TimeoutException timeoutException) {
            this.reportError(project, "readelf timed out after " + readelfTimeout + " seconds. Use +" + IBuildConfigParserConstants.Directive.READELF_TIMEOUT.toString() + "+<timeout_seconds> build configuration directive to increase timeout.");
            return null;
        }
        catch (IOException e) {
            this.reportError(project, "readelf failed due to: " + e.getMessage());
            return null;
        }
        if (readelfProc.getExitValue() != 0) {
            this.reportError(project, "readelf failed due to: \n\n\n" + readelfProc.getErrorOutput());
            return null;
        }
        String readelfStdOut = readelfProc.getStandardOutput();
        if (readelfStdOut.trim().isEmpty()) {
            this.reportError(project, "The provided shared libraries do not include debug information about their source files.");
            return null;
        }
        DVTBuildConsoleRegistry.getConsole((IProject)project).print("readelf done, parsing output...");
        if (monitor.isCanceled()) {
            return null;
        }
        final long timeout = System.currentTimeMillis() + (long)(readelfTimeout * 1000);
        SubProgressMonitor timeoutMonitor = new SubProgressMonitor(monitor, 0){

            public boolean isCanceled() {
                return System.currentTimeMillis() > timeout || super.isCanceled();
            }
        };
        ReadelfParser readelfParser = new ReadelfParser((IProgressMonitor)timeoutMonitor, readelfStdOut){

            @Override
            void reportWarning(String message) {
                CDTBuildContributor.this.reportWarning(project, message);
            }

            @Override
            void reportError(String message) {
                CDTBuildContributor.this.reportError(project, message);
            }
        };
        readelfParser.parse();
        Set<String> result = readelfParser.getSourceFiles();
        DVTBuildConsoleRegistry.getConsole((IProject)project).print("Found " + result.size() + " C/C++ files");
        ArrayList<String> messages = new ArrayList<String>();
        Iterator<String> iterator = result.iterator();
        while (iterator.hasNext()) {
            String next = iterator.next();
            boolean canRead = new File(next).canRead();
            if (!canRead) {
                iterator.remove();
            }
            messages.add("    " + (canRead ? "" : "[non existing] ") + next);
        }
        Collections.sort(messages);
        for (String message : messages) {
            DVTBuildConsoleRegistry.getConsole((IProject)project).print(message);
        }
        return result;
    }

    private void reportError(IProject project, String message) {
        this.report(project, 2, message);
    }

    private void reportWarning(IProject project, String message) {
        this.report(project, 1, message);
    }

    private void report(IProject project, int severity, String message) {
        String severityString = severity == 2 ? "Error" : (severity == 1 ? "Warning" : "Info");
        DVTBuildConsoleRegistry.getConsole((IProject)project).print("*** " + severityString + ": " + message + "\n\n");
        try {
            IMarker bcMarker = project.createMarker(DVTProblemCategories.BUILDCONFIG.getMarkerId());
            bcMarker.setAttribute("severity", severity);
            bcMarker.setAttribute("message", (Object)(message.length() < 1024 ? message : message.substring(0, 1023)));
        }
        catch (CoreException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    private Set<String> collectIncludedFilesFromTops(IProject project, List<String> cTopFiles) {
        String gccPath = GCCUtils.getGCCPath((IProject)project);
        if (gccPath == null) {
            this.reportError(project, "GCC executable not found. Use +" + IBuildConfigParserConstants.Directive.GCC.toString() + "+<path_to_gcc> build configuration directive to specify path to GCC.");
            return null;
        }
        ArrayList<String> gccArgs = new ArrayList<String>();
        gccArgs.add(gccPath);
        gccArgs.add("-M");
        gccArgs.add("-MG");
        gccArgs.add("-H");
        gccArgs.addAll(Arrays.asList(DebugPlugin.parseArguments((String)BuildConfigManager.getGccArgs((IProject)project))));
        this.cTopFilesList = cTopFiles;
        for (String cTopFile : cTopFiles) {
            gccArgs.add(cTopFile);
        }
        Cflags cflags = BuildConfigManager.getCflags((IProject)project);
        if (cflags != null) {
            for (String define : cflags.defines.keySet()) {
                String defineArg = "-D" + define;
                String value = (String)cflags.defines.get(define);
                if (value != null) {
                    defineArg = String.valueOf(defineArg) + "=" + value;
                }
                gccArgs.add(defineArg);
            }
            for (String imacro : cflags.imacros) {
                gccArgs.add("-imacros " + imacro);
            }
            for (String incdir : cflags.incdirs) {
                gccArgs.add("-I" + incdir);
            }
            for (String include : cflags.includes) {
                gccArgs.add("-include " + include);
            }
        }
        DVTBuildConsoleRegistry.getConsole((IProject)project).print(DVTStringUtil.join(gccArgs, (String)" \\\n    "));
        int gccTimeout = BuildConfigManager.getGccTimeout((IProject)project);
        DVTProcessRunner gccProc = new DVTProcessRunner(gccArgs);
        try {
            gccProc.run(null, (long)gccTimeout * 1000L);
        }
        catch (DVTProcessRunner.TimeoutException timeoutException) {
            this.reportError(project, "GCC timed out after " + gccTimeout + " seconds. Use +" + IBuildConfigParserConstants.Directive.GCC_TIMEOUT.toString() + "+<timeout_seconds> build configuration directive to increase timeout.");
            return null;
        }
        catch (IOException e) {
            this.reportError(project, "GCC failed due to: " + e.getMessage());
            return null;
        }
        if (gccProc.getExitValue() != 0) {
            this.reportError(project, "GCC failed due to: \n\n\n" + gccProc.getErrorOutput());
            return null;
        }
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        this.gccStdOut = gccProc.getStandardOutput();
        this.gccStdErr = gccProc.getErrorOutput();
        boolean isWinOS = DVTProfilingUtils.isWinOS();
        String[] stringArray = this.gccStdOut.trim().split("\\s+");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String piece = stringArray[n2];
            if (!(piece.length() > 0 && piece.charAt(0) == '.' || !Path.fromOSString((String)piece).isAbsolute() || isWinOS && ("/".equals(piece) || "\\".equals(piece)))) {
                result.add(piece);
            }
            ++n2;
        }
        DVTBuildConsoleRegistry.getConsole((IProject)project).print("Found " + result.size() + " C/C++ files:");
        Iterator iterator = result.iterator();
        while (iterator.hasNext()) {
            DVTBuildConsoleRegistry.getConsole((IProject)project).print("    " + (String)iterator.next());
        }
        return result;
    }

    public void clean(IProgressMonitor monitor) throws CoreException {
        RfProject rfProject = RfManager.getInstance().getRfProject(this.getProject());
        if (rfProject != null) {
            rfProject.clean();
        }
        CDTBuildContributor.deleteMarkersAndProperties(this.getProject());
    }

    public boolean notifyAfterIncremental() {
        return true;
    }

    public boolean isEnabled(IProject project) {
        INatureContributor contributor = NatureContributors.getContributor((LanguageKind)LanguageKind.CPP);
        if (contributor == null) {
            return false;
        }
        return contributor.hasNature(project);
    }

    public boolean hasNature(String natureID) {
        return false;
    }

    public int analyzeDelta(IResourceDelta delta, IProgressMonitor monitor, Map<LanguageKind, Set<FileCompileInfo>> changedFiles) throws CoreException {
        this.fDeltaChanged.clear();
        this.fDeltaRemoved.clear();
        changedFiles.put(LanguageKind.CPP, this.fDeltaChanged);
        delta.accept(new IResourceDeltaVisitor(){

            public boolean visit(IResourceDelta delta) throws CoreException {
                IResource resource = delta.getResource();
                if (!(resource instanceof IFile)) {
                    return true;
                }
                if (delta.getFlags() == 0x100000) {
                    return false;
                }
                IFile iFile = (IFile)resource;
                ILanguage cdtLanguage = LanguageManager.getInstance().getLanguageForFile(iFile, null);
                if (cdtLanguage == null) {
                    return false;
                }
                if (delta.getKind() == 1 || (delta.getFlags() & 0x100) != 0) {
                    CDTBuildContributor.this.fDeltaChanged.add(new FileCompileInfo(iFile));
                } else if (delta.getKind() == 2) {
                    CDTBuildContributor.this.fDeltaRemoved.add(iFile);
                }
                return false;
            }
        });
        return this.fDeltaChanged.size() + this.fDeltaRemoved.size();
    }

    protected void incrementalBuild(IProgressMonitor monitor) throws CoreException {
        CDTUtils.waitForCDTIndexerIdle();
        if (!this.shouldRunCodan(CdtBuildKind.INCR)) {
            return;
        }
        String projectPrefix = String.valueOf(this.getProject().getName()) + ": ";
        if (this.fDeltaChanged.size() + this.fDeltaRemoved.size() != 0) {
            block7: {
                this.fIncrMonitor = new SubProgressMonitor(monitor, 1000);
                int deltaStep = 1000 / (this.fDeltaChanged.size() + this.fDeltaRemoved.size());
                this.fIncrMonitor.beginTask(String.valueOf(projectPrefix) + "Processing Deltas ...", 1000);
                this.fIncrMonitorBegin = true;
                int i = 0;
                int workSize = this.fDeltaChanged.size();
                for (FileCompileInfo fileCompileInfo : this.fDeltaChanged) {
                    IFile file;
                    if (fileCompileInfo == null || (file = fileCompileInfo.getFile()) == null) continue;
                    ++i;
                    if (!this.fIncrMonitor.isCanceled()) {
                        this.fIncrMonitor.subTask(String.valueOf(projectPrefix) + "Analyzing added (" + i + "/" + workSize + ") " + file.getLocation().toOSString() + "...");
                        if (DVTFileUtils.getInstance().shouldIncrementalBuild(null, fileCompileInfo, this.getProject())) {
                            this.fCodanBuilder.processResource((IResource)fileCompileInfo.getFile(), monitor, CheckerLaunchMode.RUN_ON_INC_BUILD);
                        }
                        this.fIncrMonitor.worked(deltaStep);
                        continue;
                    }
                    break block7;
                }
                i = 0;
                workSize = this.fDeltaRemoved.size();
                for (IFile file : this.fDeltaRemoved) {
                    ++i;
                    if (this.fIncrMonitor.isCanceled()) break;
                    this.fIncrMonitor.subTask(String.valueOf(projectPrefix) + "Analyzing removed (" + i + "/" + workSize + ") " + file.getLocation().toOSString() + "...");
                    this.fCodanBuilder.processResource((IResource)file, monitor, CheckerLaunchMode.RUN_ON_INC_BUILD);
                    this.fIncrMonitor.worked(deltaStep);
                }
            }
            if (this.fIncrMonitorBegin && !this.fIncrMonitorDone) {
                this.fIncrMonitor.done();
                this.fIncrMonitorDone = true;
            }
        }
    }

    public IRfSingleLangProject getIRfProject() {
        return RfManager.getInstance().getRfProjectWithoutRestore(this.getProject());
    }

    public String getDisplayName() {
        return "C/C++";
    }

    private void createAutoLinkedResources(final IProject project, IProgressMonitor monitor) throws CoreException {
        if (!this.fResources2CreateSet.isEmpty()) {
            TestHelper.fAutoLinkTime -= (double)System.currentTimeMillis();
        }
        DVTAutoLinkManager.getInstance().startWorkspaceOperation(project, true);
        DVTAutoLinkManager.IAutoLinkOperation op = new DVTAutoLinkManager.IAutoLinkOperation(){

            public void run(Map<IPath, LinkDescription> cachedLinksMap) throws CoreException {
                long time = System.currentTimeMillis();
                HashSet<String> files = new HashSet<String>();
                for (ParserPath parserPath : CDTBuildContributor.this.fResources2CreateSet) {
                    files.add(new File(parserPath.path).getName());
                }
                HashMap<String, List<IFile>> fileCandidates = new HashMap<String, List<IFile>>();
                HashMap<IPath, IPath> directorySymlinks = new HashMap<IPath, IPath>();
                DVTFileUtils.getInstance().cacheDirectories(project, files, fileCandidates, directorySymlinks);
                DVTLogger.INSTANCE.logDebug("AUTO_LINKED: Time to collect " + directorySymlinks.size() + " symlinked directories takes " + (System.currentTimeMillis() - time));
                for (ParserPath parserPath : CDTBuildContributor.this.fResources2CreateSet) {
                    IFile file = CDTBuildContributor.this.createAutoLinkedResource(project, Path.fromOSString((String)parserPath.path), fileCandidates, directorySymlinks, cachedLinksMap);
                    if (file == null) continue;
                    String resourcePath = file.getProjectRelativePath().toOSString();
                    PropertiesManager.addParser2ResourceMapProperty((IProject)project, (String)parserPath.path, (String)resourcePath);
                    PropertiesManager.addSessionProperty((IResource)file, (String)PropertyTypes.QN_IMPORTED_FILE, (String)IBuildConfigParserConstants.LanguageSyntax.C.id);
                }
            }
        };
        DVTAutoLinkManager.getInstance().modifyWorkspaceOperation(project, CDT_BUILDER_CALLER_NAME, op, false);
        DVTAutoLinkManager.getInstance().endWorkspaceOperation(project, false);
        if (!this.fResources2CreateSet.isEmpty()) {
            TestHelper.fAutoLinkTime += (double)System.currentTimeMillis();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private IFile createAutoLinkedResource(IProject project, IPath parserPath, Map<String, List<IFile>> fileCandidates, Map<IPath, IPath> directorySymlinks, Map<IPath, LinkDescription> cachedLinksMap) {
        try {
            boolean isAutoLinkedResourcesEnable = BuildConfigManager.isAutoLinkedResources((IProject)project);
            IFile file = DVTFileUtils.getInstance().findProjectFileAndRegister(project, parserPath, fileCandidates, directorySymlinks);
            if (file != null && file.getLocation() != null) {
                if (isAutoLinkedResourcesEnable) {
                    DVTAutoLinkManager.getInstance().validateAutoLink(project, file);
                    return file;
                }
                if (!file.getProjectRelativePath().segment(0).equals("DVT Auto-Linked")) return file;
                return null;
            }
            if (!isAutoLinkedResourcesEnable) {
                return null;
            }
            if (DVTAutoLinkManager.getInstance().hasError(project, 2)) return null;
            if (DVTAutoLinkManager.getInstance().hasError(project, 1)) {
                return null;
            }
            file = DVTFileUtils.getInstance().findProjectFileAndRegister(project, parserPath, fileCandidates, directorySymlinks);
            if (file != null && file.getLocation() != null) {
                DVTAutoLinkManager.getInstance().validateAutoLink(project, file);
                return file;
            }
            IFile projectFile = project.getFile(".project");
            boolean autolinkUsingLinks = DVTAutoLinkManager.getInstance().autolinkUsingLinksForProject(project);
            boolean readOnly = projectFile.getResourceAttributes().isReadOnly();
            if (!readOnly) return DVTAutoLinkManager.getInstance().createAutoLink(project, parserPath, BuildConfigManager.getAutoLinkedRoots((IProject)project), cachedLinksMap, false);
            if (!autolinkUsingLinks) return DVTAutoLinkManager.getInstance().createAutoLink(project, parserPath, BuildConfigManager.getAutoLinkedRoots((IProject)project), cachedLinksMap, false);
            DVTAutoLinkManager.getInstance().reportError(project, 1);
            return file;
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            DVTAutoLinkManager.getInstance().reportError(project, 2);
            return null;
        }
    }

    private void updateCDTLanguageProviders(IProject project) throws CoreException {
        ICProjectDescriptionManager manager;
        ICProjectDescription projectDescription;
        String gccArgs;
        String gccPath = BuildConfigManager.getGccPath((IProject)project);
        if (gccPath == null || gccPath.trim().isEmpty()) {
            gccPath = null;
        }
        if ((gccArgs = BuildConfigManager.getGccArgs((IProject)project)) == null || gccArgs.trim().isEmpty()) {
            gccArgs = null;
        }
        if ((projectDescription = (manager = CCorePlugin.getDefault().getProjectDescriptionManager()).getProjectDescription(project, 4)) == null) {
            return;
        }
        ICConfigurationDescription configDescription = projectDescription.getActiveConfiguration();
        if (configDescription == null) {
            return;
        }
        CPPNatureContributor.setLanguageProviders(configDescription, gccPath, gccArgs);
        manager.setProjectDescription(project, projectDescription);
        projectDescription.setReadOnly(true, true);
    }

    public void postMixedLangBuild(IProject project, int fullBuild) {
        RfProject rfProject = RfManager.getInstance().getRfProject(project);
        if (rfProject == null) {
            return;
        }
        rfProject.persist(false, true, false);
    }

    private void updateDeprecatedProject(IProgressMonitor monitor) {
        try {
            IProject project = this.getProject();
            if (project == null || !project.isAccessible()) {
                return;
            }
            if (!(project.hasNature("ro.amiq.dvt.cdt.cppextnature") || DVTNature.hasAnyDVTNatureEnabled((IProject)project) && project.hasNature("org.eclipse.cdt.core.cnature"))) {
                return;
            }
            DVTNature.addNature((IProject)project, (String)"ro.amiq.dvt.cdt.cppnature", (IProgressMonitor)monitor);
        }
        catch (Exception exception) {}
    }

    public static void deleteMarkersAndProperties(IProject project) {
        try {
            project.deleteMarkers("org.eclipse.cdt.codan.core.codanProblem", true, 2);
            final ArrayList refreshList = new ArrayList();
            project.accept(new IResourceVisitor(){

                public boolean visit(IResource resource) throws CoreException {
                    if (PropertiesManager.getSessionProperty((IResource)resource, (String)PropertyTypes.QN_IMPORTED_FILE) != null) {
                        PropertiesManager.addSessionProperty((IResource)resource, (String)PropertyTypes.QN_IMPORTED_FILE, null);
                        refreshList.add(resource);
                        return true;
                    }
                    return false;
                }
            });
            DVTAbstractDecorator.refresh((String)"ro.amiq.dvt.CompiledFileDecorator", (Object[])refreshList.toArray());
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }
}

