/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.cdt.builders;

import java.io.File;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import ro.amiq.dvt.buildconfig.IBuildConfigParserConstants;

public class CdtFileTypeMap {
    Map<String, IBuildConfigParserConstants.CdtFileType> fMap = new LinkedHashMap<String, IBuildConfigParserConstants.CdtFileType>();

    public IBuildConfigParserConstants.CdtFileType putNameOrExtFromPath(String path, IBuildConfigParserConstants.CdtFileType type) {
        if (path == null || type == null) {
            return null;
        }
        String name = new File(path).getName();
        int position = name.lastIndexOf(46);
        String nameOrExtension = position < 0 || position == name.length() - 1 ? name : name.substring(position);
        return this.fMap.put(nameOrExtension, type);
    }

    public IBuildConfigParserConstants.CdtFileType put(String nameOrExtension, IBuildConfigParserConstants.CdtFileType type) {
        if (nameOrExtension == null || type == null) {
            return null;
        }
        return this.fMap.put(nameOrExtension, type);
    }

    public Set<String> computeNames(IBuildConfigParserConstants.CdtFileType ft) {
        HashSet<String> result = new HashSet<String>();
        this.fMap.forEach((nameOrExt, cdtFileType2) -> {
            if (cdtFileType2 == ft && nameOrExt != null && !nameOrExt.isEmpty() && nameOrExt.charAt(0) != '.') {
                result.add((String)nameOrExt);
            }
        });
        return result;
    }

    public Set<String> computeExtensions(IBuildConfigParserConstants.CdtFileType ft) {
        HashSet<String> result = new HashSet<String>();
        this.fMap.forEach((nameOrExt, cdtFileType2) -> {
            if (cdtFileType2 == ft && nameOrExt != null && !nameOrExt.isEmpty() && nameOrExt.charAt(0) == '.') {
                result.add(nameOrExt.substring(1));
            }
        });
        return result;
    }

    public boolean isEmpty() {
        return this.fMap.isEmpty();
    }
}

