/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.cdt.builders;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import ro.amiq.dvt.cdt.builders.CountingLinesStringScanner;
import ro.amiq.dvt.startup.core.DVTLogger;

public abstract class ReadelfParser {
    private static final String THE_FILE_NAME_TABLE = "The File Name Table";
    private static final String THE_DIRECTORY_TABLE = "The Directory Table";
    private static final String DW_AT_COMP_DIR = "DW_AT_comp_dir";
    private static final Pattern DW_AT_COMP_DIR_PATTERN = Pattern.compile("\\s*<[0-9a-fA-F]+>\\s+DW_AT_comp_dir.*?:\\s+([^:]+)");
    private static final String DW_AT_NAME = "DW_AT_name";
    private static final Pattern DW_AT_NAME_PATTERN = Pattern.compile("\\s*<[0-9a-fA-F]+>\\s+DW_AT_name.*?:\\s+([^:]+)");
    private static final String DW_TAG_COMPILE_UNIT = "DW_TAG_compile_unit";
    private static final Pattern DW_TAG_COMPILE_UNIT_PATTERN = Pattern.compile("\\s*<[0-9a-fA-F]+><[0-9a-fA-F]+>:\\s+Abbrev Number:\\s+[0-9]+\\s+\\(DW_TAG_compile_unit\\)");
    private static final String DW_TAG = "DW_TAG";
    private static final Pattern DW_TAG_PATTERN = Pattern.compile("\\s*<[0-9a-fA-F]+><[0-9a-fA-F]+>:\\s+Abbrev Number:\\s+[0-9]+\\s+\\(DW_TAG(_*[a-z]+_*)+\\)");
    private String fReadelfOutput;
    private List<String> fDwAtCompdirs = new ArrayList<String>();
    private List<String> fDwAtNames = new ArrayList<String>();
    private List<Map<String, String>> fDirtabs = new ArrayList<Map<String, String>>();
    private List<Map<String, String>> fFiletabs = new ArrayList<Map<String, String>>();
    private Set<String> fSourceFiles = new LinkedHashSet<String>();
    private IProgressMonitor fMonitor;

    public ReadelfParser(IProgressMonitor monitor, String readelfOutput) {
        this.fMonitor = monitor == null ? new NullProgressMonitor() : monitor;
        this.fReadelfOutput = readelfOutput;
    }

    public void parse() {
        CountingLinesStringScanner scanner = new CountingLinesStringScanner(this.fReadelfOutput);
        block0: while (scanner.hasNextLine()) {
            if (this.fMonitor.isCanceled()) break;
            String line = scanner.nextLine();
            if (line.contains(THE_DIRECTORY_TABLE)) {
                this.parseDirFileTab(line, scanner);
                continue;
            }
            boolean foundCompUnit = this.parseUsingPattern(line, DW_TAG_COMPILE_UNIT, DW_TAG_COMPILE_UNIT_PATTERN, null);
            if (!foundCompUnit) continue;
            boolean foundDwAtComp = false;
            boolean foundDwAtName = false;
            boolean foundDwTag = false;
            while (!(!scanner.hasNextLine() || foundDwAtComp && foundDwAtName)) {
                line = scanner.nextLine();
                if (this.fMonitor.isCanceled() || (foundCompUnit = this.parseUsingPattern(line, DW_TAG_COMPILE_UNIT, DW_TAG_COMPILE_UNIT_PATTERN, null)) || (foundDwTag = this.parseUsingPattern(line, DW_TAG, DW_TAG_PATTERN, null))) continue block0;
                if (!foundDwAtName) {
                    foundDwAtName = this.parseUsingPattern(line, DW_AT_NAME, DW_AT_NAME_PATTERN, this.fDwAtNames);
                }
                if (foundDwAtComp) continue;
                foundDwAtComp = this.parseUsingPattern(line, DW_AT_COMP_DIR, DW_AT_COMP_DIR_PATTERN, this.fDwAtCompdirs);
            }
        }
        scanner.close();
        if (this.fMonitor.isCanceled()) {
            return;
        }
        this.computeSourceFiles();
    }

    private void computeSourceFiles() {
        int nofSections = this.fDwAtNames.size();
        if (nofSections != this.fDwAtCompdirs.size() || nofSections != this.fDirtabs.size() || nofSections != this.fFiletabs.size()) {
            StringBuilder message = new StringBuilder("Found different number of:\n");
            message.append(DW_AT_NAME).append(": ").append(this.fDwAtNames.size()).append("\n");
            message.append(DW_AT_COMP_DIR).append(": ").append(this.fDwAtCompdirs.size()).append("\n");
            message.append(THE_DIRECTORY_TABLE).append(": ").append(this.fDirtabs.size()).append("\n");
            message.append(THE_FILE_NAME_TABLE).append(": ").append(this.fFiletabs.size()).append("\n");
            this.reportError(message.toString());
            return;
        }
        int i = 0;
        while (i < nofSections) {
            String compdir = this.fDwAtCompdirs.get(i);
            Map<String, String> filetab = this.fFiletabs.get(i);
            Map<String, String> dirtab = this.fDirtabs.get(i);
            for (String fileRelativePath : filetab.keySet()) {
                File dirFile;
                if (this.fMonitor.isCanceled()) {
                    return;
                }
                Path path = new Path(fileRelativePath);
                String filename = path.lastSegment();
                String dirName = dirtab.get(filetab.get(filename));
                if (dirName == null) {
                    dirName = "";
                }
                if ((dirFile = new File(dirName)).isAbsolute()) {
                    this.fSourceFiles.add(new File(dirFile, fileRelativePath).getAbsolutePath());
                    continue;
                }
                if (compdir == null) {
                    this.reportWarning("Skipping " + fileRelativePath + " (no dirtab entry and no comp root)");
                    continue;
                }
                try {
                    this.fSourceFiles.add(new File(new File(compdir, dirName), fileRelativePath).getCanonicalPath());
                }
                catch (IOException e) {
                    DVTLogger.INSTANCE.logError((Throwable)e);
                }
            }
            ++i;
        }
    }

    private void parseDirFileTab(String line, CountingLinesStringScanner scanner) {
        if (!line.trim().startsWith(THE_DIRECTORY_TABLE)) {
            return;
        }
        LinkedHashMap<String, String> dirtab = new LinkedHashMap<String, String>();
        while (scanner.hasNextLine()) {
            if (this.fMonitor.isCanceled()) {
                return;
            }
            String dirLine = scanner.nextLine().trim();
            if (dirLine.isEmpty()) break;
            String[] split = dirLine.split("\\s+");
            String key = null;
            String value = null;
            if (split.length == 2) {
                key = split[0];
                value = split[1];
            } else if (split.length == 1) {
                key = Integer.toString(dirtab.size() + 1);
                value = split[0];
            }
            if (key == null || value == null) continue;
            dirtab.put(key, value);
        }
        this.fDirtabs.add(dirtab);
        while (scanner.hasNextLine()) {
            if (this.fMonitor.isCanceled()) {
                return;
            }
            line = scanner.nextLine().trim();
            if (line.isEmpty()) continue;
            if (line.startsWith(THE_FILE_NAME_TABLE)) break;
            this.reportWarning("Bad format (expecting The File Name Table immediately after The Directory Table)");
            return;
        }
        scanner.nextLine();
        LinkedHashMap<String, String> filetab = new LinkedHashMap<String, String>();
        while (scanner.hasNextLine()) {
            if (this.fMonitor.isCanceled()) {
                return;
            }
            String dirLine = scanner.nextLine().trim();
            if (dirLine.isEmpty()) break;
            String[] split = dirLine.split("\\s+");
            if (split.length != 5) continue;
            try {
                filetab.put(split[4], split[1]);
            }
            catch (NumberFormatException numberFormatException) {
                this.reportWarning("Bad format (expecting The File Name Table immediately after The Directory Table)");
            }
        }
        this.fFiletabs.add(filetab);
    }

    private boolean parseUsingPattern(String line, String dwAtName, Pattern pattern, List<String> list) {
        if (!line.contains(dwAtName)) {
            return false;
        }
        Matcher matcher = pattern.matcher(line);
        if (!matcher.matches()) {
            return false;
        }
        if (list != null) {
            list.add(matcher.group(1).trim());
        }
        return true;
    }

    public Set<String> getSourceFiles() {
        return this.fSourceFiles;
    }

    abstract void reportWarning(String var1);

    abstract void reportError(String var1);

    static interface IQualifier {
        public boolean qualifies(String var1);
    }
}

