/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.cdt.editor.hyperlink;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import org.eclipse.cdt.core.dom.ast.IASTImageLocation;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNodeSelector;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IFunction;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ILanguage;
import org.eclipse.cdt.core.model.IWorkingCopy;
import org.eclipse.cdt.internal.core.model.ASTCache;
import org.eclipse.cdt.internal.ui.editor.ASTProvider;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.cdt.ui.ICEditor;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.hyperlink.AbstractHyperlinkDetector;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.texteditor.ITextEditor;
import ro.amiq.dvt.DVTPlugin;
import ro.amiq.dvt.core.DVTNature;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfScopeElement;
import ro.amiq.dvt.ui.editor.hyperlink.DVTHyperlinkMessages;
import ro.amiq.vlogdt.model.reflection.IRfNamedElementVisitor;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.RfManager;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfProject;
import ro.amiq.vlogdt.model.reflection.util.RfUtils;
import ro.amiq.vlogdt.model.reflection.util.VlogRfGUIReferencesUtils;
import ro.amiq.vlogdt.ui.editor.hyperlink.RfNamedElementActionHyperlink;

public class CDPIHyperlinkDetector
extends AbstractHyperlinkDetector {
    private LastHyperlink lastHyperlink;

    public IHyperlink[] detectHyperlinks(ITextViewer textViewer, final IRegion region, boolean canShowMultipleHyperlinks) {
        ITextEditor textEditor = (ITextEditor)this.getAdapter(ITextEditor.class);
        if (region == null || !(textEditor instanceof ICEditor)) {
            return null;
        }
        IEditorInput editorInput = textEditor.getEditorInput();
        if (!(editorInput instanceof IFileEditorInput)) {
            return null;
        }
        IFile file = ((IFileEditorInput)editorInput).getFile();
        if (file == null) {
            return null;
        }
        IProject project = file.getProject();
        if (project == null) {
            return null;
        }
        if (!DVTNature.hasNature((IProject)project, (String)"ro.amiq.vlogdt.VlogNature") || !DVTNature.hasNature((IProject)project, (String)"org.eclipse.cdt.core.cnature") && !DVTNature.hasNature((IProject)project, (String)"org.eclipse.cdt.core.ccnature")) {
            return null;
        }
        if (!DVTPlugin.getDefault().collect().c(project, "F7376")) {
            return null;
        }
        RfProject rfProject = RfManager.getInstance().getRfProject(project);
        if (rfProject == null) {
            return null;
        }
        IWorkingCopy workingCopy = CUIPlugin.getDefault().getWorkingCopyManager().getWorkingCopy(editorInput);
        if (workingCopy == null) {
            return null;
        }
        final Object[] astResult = new Object[2];
        IStatus status = ASTProvider.getASTProvider().runOnAST((ICElement)workingCopy, ASTProvider.WAIT_NO, null, new ASTCache.ASTRunnable(){

            public IStatus runOnAST(ILanguage lang, IASTTranslationUnit ast) {
                if (ast == null) {
                    return Status.CANCEL_STATUS;
                }
                int offset = region.getOffset();
                int length = Math.max(1, region.getLength());
                IASTNodeSelector nodeSelector = ast.getNodeSelector(null);
                IASTName selectedName = nodeSelector.findEnclosingName(offset, length);
                if (selectedName == null) {
                    return Status.CANCEL_STATUS;
                }
                IASTImageLocation linkLocation = selectedName.getImageLocation();
                if (linkLocation == null) {
                    return Status.CANCEL_STATUS;
                }
                astResult[0] = new Region(linkLocation.getNodeOffset(), linkLocation.getNodeLength());
                IBinding binding = selectedName.resolveBinding();
                if (!(binding instanceof IFunction)) {
                    return Status.CANCEL_STATUS;
                }
                astResult[1] = ((IFunction)binding).getName();
                return Status.OK_STATUS;
            }
        });
        if (status != Status.OK_STATUS) {
            return null;
        }
        IRegion newRegion = (IRegion)astResult[0];
        String functionName = (String)astResult[1];
        if (this.lastHyperlink != null && this.lastHyperlink.isValid(functionName, textViewer)) {
            return this.lastHyperlink.getHyperlinks();
        }
        IHyperlink[] hyperlinks = this.createDPIHyperlinks(functionName, new HyperlinkContext(rfProject, newRegion));
        this.lastHyperlink = new LastHyperlink(functionName, textViewer, hyperlinks);
        return hyperlinks;
    }

    private IHyperlink[] createDPIHyperlinks(final String functionName, HyperlinkContext context) {
        final RfFunction[] dpiFunction = new RfFunction[1];
        context.rfProject.accept(new IRfNamedElementVisitor(){

            public boolean visit(RfNamedElement namedElement) {
                if (namedElement instanceof RfFunction && ((RfFunction)namedElement).isDPI()) {
                    String dpiFunctionName = ((RfFunction)namedElement).getCIdentifier();
                    if (dpiFunctionName == null) {
                        dpiFunctionName = namedElement.getName();
                    }
                    if (dpiFunctionName.equals(functionName)) {
                        dpiFunction[0] = (RfFunction)namedElement;
                        return false;
                    }
                }
                return true;
            }
        });
        if (dpiFunction[0] == null) {
            return null;
        }
        RfFunction rfFunction = dpiFunction[0];
        ArrayList<Object> hyperlinks = new ArrayList<Object>();
        hyperlinks.add(new OpenHyperlink(context.region, rfFunction, true));
        if (rfFunction.isExportDPI()) {
            hyperlinks.add(new OpenHyperlink(context.region, rfFunction, false));
        }
        hyperlinks.add(new ShowUsages(context.region, rfFunction));
        return hyperlinks.toArray(new IHyperlink[hyperlinks.size()]);
    }

    private static class HyperlinkContext {
        public final RfProject rfProject;
        public final IRegion region;

        public HyperlinkContext(RfProject rfProject, IRegion region) {
            this.rfProject = rfProject;
            this.region = region;
        }
    }

    private static class LastHyperlink {
        private final String functionName;
        private final WeakReference<ITextViewer> textViewerRef;
        private final IHyperlink[] hyperlinks;

        public LastHyperlink(String functionName, ITextViewer textViewer, IHyperlink[] hyperlinks) {
            this.functionName = functionName;
            this.textViewerRef = new WeakReference<ITextViewer>(textViewer);
            this.hyperlinks = hyperlinks;
        }

        public boolean isValid(String functioName, ITextViewer textViewer) {
            return this.textViewerRef.get() == textViewer && this.functionName.equals(functioName);
        }

        public IHyperlink[] getHyperlinks() {
            return this.hyperlinks;
        }
    }

    private static class OpenHyperlink
    implements IHyperlink {
        private final IRegion region;
        private final RfFunction rfFunction;
        private final boolean isDeclaration;

        public OpenHyperlink(IRegion region, RfFunction rfFunction, boolean isDeclaration) {
            this.region = region;
            this.rfFunction = rfFunction;
            this.isDeclaration = isDeclaration;
        }

        public void open() {
            if (this.rfFunction.getRfProject() == null) {
                return;
            }
            RfNamedElementActionHyperlink openActionHyperlink = RfUtils.createOpenAction((IRfNamedElement)this.rfFunction, (IProject)this.rfFunction.getRfProject().getProject(), (IRegion)this.region, (!this.isDeclaration ? 1 : 0) != 0);
            if (openActionHyperlink != null) {
                openActionHyperlink.open();
            }
        }

        public String getTypeLabel() {
            return null;
        }

        public String getHyperlinkText() {
            return this.isDeclaration ? DVTHyperlinkMessages.openSystemVerilogDeclaration : DVTHyperlinkMessages.openSystemVerilogImplementation;
        }

        public IRegion getHyperlinkRegion() {
            return this.region;
        }
    }

    private static class ShowUsages
    implements IHyperlink {
        private final IRegion region;
        private final RfFunction rfFunction;

        public ShowUsages(IRegion region, RfFunction rfFunction) {
            this.region = region;
            this.rfFunction = rfFunction;
        }

        public void open() {
            if (this.rfFunction.getRfProject() == null) {
                return;
            }
            VlogRfGUIReferencesUtils.showUsagesAction((IRfNamedElement)this.rfFunction, (IRfScopeElement)this.rfFunction.getEnclosingScope(), null, (boolean)false, (IProject)this.rfFunction.getRfProject().getProject(), (String)this.rfFunction.getName());
        }

        public String getTypeLabel() {
            return null;
        }

        public String getHyperlinkText() {
            return DVTHyperlinkMessages.showSystemVerilogUsages;
        }

        public IRegion getHyperlinkRegion() {
            return this.region;
        }
    }
}

