/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.cdt.editor.hyperlink;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.PatternSyntaxException;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IFunction;
import org.eclipse.cdt.core.index.IIndex;
import org.eclipse.cdt.core.index.IIndexBinding;
import org.eclipse.cdt.core.index.IIndexName;
import org.eclipse.cdt.core.index.IndexFilter;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.internal.ui.util.EditorUtility;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.NewSearchUI;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.texteditor.ITextEditor;
import ro.amiq.dvt.DVTPlugin;
import ro.amiq.dvt.cdt.ui.actions.CSearchBindingQuery;
import ro.amiq.dvt.cdt.ui.actions.Location;
import ro.amiq.dvt.core.DVTNature;
import ro.amiq.dvt.model.reflection.IDVTHyperlink;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfNamedElementAndScope;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.editor.hyperlink.DVTHyperlinkMessages;
import ro.amiq.dvt.ui.editor.hyperlink.IHyperlinkContext;
import ro.amiq.dvt.ui.editor.hyperlink.IHyperlinkDetectorContributor;
import ro.amiq.vlogdt.model.reflection.RfFunction;

public class VlogDPIHyperlinkDetector
implements IHyperlinkDetectorContributor {
    private static final IndexFilter FUNCTION_INDEX_FILTER = new IndexFilter(){

        public boolean acceptBinding(IBinding binding) throws CoreException {
            return binding instanceof IFunction;
        }
    };
    private static final Comparator<IHyperlink> HYPERLINKS_COMPARATOR = new Comparator<IHyperlink>(){

        @Override
        public int compare(IHyperlink o1, IHyperlink o2) {
            if (o1 == o2) {
                return 0;
            }
            if (o1 == null) {
                return -1;
            }
            if (o2 == null) {
                return 1;
            }
            return o1.getHyperlinkText().compareTo(o2.getHyperlinkText());
        }
    };

    public void insertHyperlinks(List<IDVTHyperlink> hyperlinks, IHyperlinkContext context) {
        IProject project = context.getProject();
        if (project == null) {
            return;
        }
        if (!DVTNature.hasNature((IProject)project, (String)"ro.amiq.vlogdt.VlogNature") || !DVTNature.hasNature((IProject)project, (String)"org.eclipse.cdt.core.cnature") && !DVTNature.hasNature((IProject)project, (String)"org.eclipse.cdt.core.ccnature")) {
            return;
        }
        if (!DVTPlugin.getDefault().collect().c(project, "F7376")) {
            return;
        }
        IRfNamedElementAndScope namedElementAndScope = context.getNamedElementAndScope();
        if (namedElementAndScope == null) {
            return;
        }
        IRfNamedElement namedElement = namedElementAndScope.getIRfNamedElement();
        if (namedElement == null) {
            return;
        }
        if (!(namedElement instanceof RfFunction)) {
            return;
        }
        RfFunction rfFunction = (RfFunction)namedElement;
        String functionName = rfFunction.getCIdentifier();
        if (functionName == null) {
            functionName = rfFunction.getName();
        }
        if (rfFunction.isImportDPI() || rfFunction.isExportDPI()) {
            hyperlinks.addAll(this.createDPIHyperlinks(functionName, rfFunction.isExportDPI(), context));
        }
    }

    private List<IDVTHyperlink> createDPIHyperlinks(String functionName, boolean isExport, IHyperlinkContext context) {
        ArrayList<IDVTHyperlink> hyperlinks = new ArrayList<IDVTHyperlink>();
        IIndex index = null;
        try {
            String projectName = context.getProject().getName();
            ICProject cproject = CoreModel.getDefault().getCModel().getCProject(projectName);
            if (cproject == null) {
                List<IDVTHyperlink> list = Collections.emptyList();
                return list;
            }
            index = CCorePlugin.getIndexManager().getIndex(cproject, 1);
            index.acquireReadLock();
            IIndexBinding[] bindings = index.findBindings(functionName.toCharArray(), FUNCTION_INDEX_FILTER, (IProgressMonitor)new NullProgressMonitor());
            if (bindings == null) {
                List<IDVTHyperlink> list = Collections.emptyList();
                return list;
            }
            try {
                HashSet<Location> declarations = new HashSet<Location>();
                HashSet<Location> definitions = new HashSet<Location>();
                boolean showUsages = false;
                IIndexBinding[] iIndexBindingArray = bindings;
                int n = bindings.length;
                int n2 = 0;
                while (n2 < n) {
                    IIndexBinding binding = iIndexBindingArray[n2];
                    try {
                        declarations.addAll(this.createLocations(index.findNames((IBinding)binding, 1)));
                        if (!isExport) {
                            definitions.addAll(this.createLocations(index.findNames((IBinding)binding, 2)));
                        }
                        showUsages = showUsages || index.findNames((IBinding)binding, 4).length > 0;
                    }
                    catch (CoreException e) {
                        DVTLogger.INSTANCE.logError((Throwable)e);
                    }
                    ++n2;
                }
                for (Location declaration : declarations) {
                    hyperlinks.add(new OpenHyperlink(context.getRegion(), declaration, true));
                }
                for (Location definition : definitions) {
                    hyperlinks.add(new OpenHyperlink(context.getRegion(), definition, false));
                }
                if (showUsages) {
                    hyperlinks.add(new SearchHyperlink(context.getRegion(), cproject, functionName, bindings));
                }
                Collections.sort(hyperlinks, HYPERLINKS_COMPARATOR);
            }
            catch (InterruptedException | CoreException e) {
                DVTLogger.INSTANCE.logError(e);
            }
        }
        finally {
            if (index != null) {
                index.releaseReadLock();
            }
        }
        return hyperlinks;
    }

    private Set<Location> createLocations(IIndexName[] names) {
        HashSet<Location> result = new HashSet<Location>();
        IIndexName[] iIndexNameArray = names;
        int n = names.length;
        int n2 = 0;
        while (n2 < n) {
            IIndexName name = iIndexNameArray[n2];
            Location location = Location.create(name);
            if (location != null) {
                result.add(location);
            }
            ++n2;
        }
        return result;
    }

    private static class OpenHyperlink
    implements IDVTHyperlink {
        private final IRegion region;
        private final Location location;
        private final boolean isDeclaration;

        public OpenHyperlink(IRegion region, Location location, boolean isDeclaration) {
            this.region = region;
            this.location = location;
            this.isDeclaration = isDeclaration;
        }

        public boolean updateNonGuiPart() {
            return true;
        }

        public void updateGuiPart() {
            try {
                IEditorPart editor = EditorUtility.openInEditor((IPath)this.location.path, null, (boolean)true);
                if (editor != null && editor instanceof ITextEditor) {
                    ITextEditor textEditor = (ITextEditor)editor;
                    if (this.location.length == -1) {
                        IDocument document = textEditor.getDocumentProvider().getDocument((Object)editor.getEditorInput());
                        int newOffset = document.getLineOffset(this.location.offset);
                        int newLength = document.getLineLength(newOffset);
                        textEditor.selectAndReveal(newOffset, newLength);
                    } else {
                        textEditor.selectAndReveal(this.location.offset, this.location.length);
                    }
                }
            }
            catch (Exception e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
            }
        }

        public String getTypeLabel() {
            return null;
        }

        public String getHyperlinkText() {
            return DVTHyperlinkMessages.getMessage((String)(this.isDeclaration ? DVTHyperlinkMessages.openCPlusPlusDeclaration : DVTHyperlinkMessages.openCPlusPlusImplementation), (Object[])new Object[]{this.location.path.lastSegment()});
        }

        public IRegion getHyperlinkRegion() {
            return this.region;
        }
    }

    private static class SearchHyperlink
    implements IDVTHyperlink {
        private final IRegion region;
        private final ICProject project;
        private final String functionName;
        private final IIndexBinding[] bindings;

        public SearchHyperlink(IRegion region, ICProject project, String functionName, IIndexBinding[] bindings) {
            this.region = region;
            this.project = project;
            this.functionName = functionName;
            this.bindings = bindings;
        }

        public boolean updateNonGuiPart() {
            return true;
        }

        public void updateGuiPart() {
            try {
                CSearchBindingQuery searchQuery = new CSearchBindingQuery(this.project, this.functionName, this.bindings);
                NewSearchUI.activateSearchResultView();
                NewSearchUI.runQueryInBackground((ISearchQuery)searchQuery);
            }
            catch (PatternSyntaxException e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
            }
        }

        public String getTypeLabel() {
            return null;
        }

        public String getHyperlinkText() {
            return DVTHyperlinkMessages.showCPlusPlusUsages;
        }

        public IRegion getHyperlinkRegion() {
            return this.region;
        }
    }
}

