/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.cdt.model.reflection;

import java.io.Serializable;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.Path;
import ro.amiq.dvt.model.reflection.IRfDefElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.utils.DVTFileUtils;
import ro.amiq.dvt.utils.parser.CommentsTable;
import ro.amiq.dvt.utils.parser.IDVTFileInstance;

public class CDTFileInstance
implements IDVTFileInstance,
Serializable {
    private static final long serialVersionUID = 18125L;
    protected List<CDTFileInstance> children;
    private CDTFileInstance parent;
    private String fullPath;
    private String shortName;
    private int index;
    private String treeName;
    private ParserPath parserPath;

    public CDTFileInstance() {
    }

    public CDTFileInstance(String fullPath, int index) {
        this.fullPath = fullPath;
        this.parserPath = new ParserPath(fullPath);
        this.shortName = Paths.get(fullPath, new String[0]).getFileName().toString();
        this.index = index;
        this.treeName = String.valueOf(this.shortName) + " [" + index + ']';
    }

    protected void setParent(CDTFileInstance parent) {
        this.parent = parent;
    }

    public CDTFileInstance getParent() {
        return this.parent;
    }

    public List<CDTFileInstance> getChildren() {
        return this.children;
    }

    public void addChild(CDTFileInstance child) {
        if (this.children == null) {
            this.children = new ArrayList<CDTFileInstance>();
        }
        child.setParent(this);
        this.children.add(child);
    }

    public void addChildren(List<CDTFileInstance> children) {
        if (children == null || children.isEmpty()) {
            return;
        }
        for (CDTFileInstance child : children) {
            this.addChild(child);
        }
    }

    public boolean hasChildren() {
        return this.children != null && !this.children.isEmpty();
    }

    public void removeChild(CDTFileInstance child) {
        this.children.remove(child);
    }

    public String getFullPath() {
        return this.fullPath;
    }

    public String getShortName() {
        return this.shortName;
    }

    public int getIndex() {
        return this.index;
    }

    public String getTreeName() {
        return this.treeName;
    }

    public String toString() {
        return this.treeName;
    }

    public IFile getFile(IProject project) {
        return DVTFileUtils.getInstance().findProjectFileUsingAbsolutePath(project, new Path(this.fullPath).toPortableString());
    }

    public CommentsTable getComments() {
        return null;
    }

    public ParserPath getParserPath() {
        return this.parserPath;
    }

    public void endDefElement(IRfDefElement defElement) {
    }

    public int getInvocNumber() {
        return -1;
    }

    public boolean isInstanceInScope(IRfNamedElement instance) {
        return false;
    }

    public boolean isValid() {
        return true;
    }
}

