/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.cdt.model.reflection.views;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.index.IIndex;
import org.eclipse.cdt.core.index.IIndexFile;
import org.eclipse.cdt.core.index.IIndexFileLocation;
import org.eclipse.cdt.core.index.IIndexInclude;
import org.eclipse.cdt.core.index.IndexLocationFactory;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.texteditor.ITextEditor;
import ro.amiq.dvt.DVTPlugin;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.cdt.model.reflection.CDTFileInstance;
import ro.amiq.dvt.cdt.model.reflection.RfDummyElement;
import ro.amiq.dvt.cdt.model.reflection.RfManager;
import ro.amiq.dvt.cdt.model.reflection.RfProject;
import ro.amiq.dvt.cdt.model.reflection.views.CDTLanguageElement;
import ro.amiq.dvt.cdt.model.reflection.views.CompileOrderLabelProvider;
import ro.amiq.dvt.cdt.model.reflection.views.RfTreeElementWrapper;
import ro.amiq.dvt.core.DVTNature;
import ro.amiq.dvt.model.reflection.views.IRfFilterableTreeAccessor;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.startup.core.DVTUiUtils;
import ro.amiq.dvt.symbolcollector.ISymbolCollectorPrerequisite;
import ro.amiq.dvt.symbolcollector.SymbolCollectorConfigurator;
import ro.amiq.dvt.ui.guifilters.DVTCompileOrderGUIFilterMatcher;
import ro.amiq.dvt.ui.guifilters.DVTGUIFilterMatcher;
import ro.amiq.dvt.ui.guifilters.ViewSet;
import ro.amiq.dvt.ui.problems.DVTProblemDecorator;
import ro.amiq.dvt.ui.views.DVTBaseLabelProvider;
import ro.amiq.dvt.ui.views.IDVTElementWrapper;
import ro.amiq.dvt.ui.views.UpdateJob;
import ro.amiq.dvt.ui.views.ViewsUtils;
import ro.amiq.dvt.ui.views.ViewsUtilsCommon;
import ro.amiq.dvt.ui.views.compileorder.BaseCompileOrderViewContributor;
import ro.amiq.dvt.ui.views.compileorder.CompileOrderViewInput;
import ro.amiq.dvt.ui.views.compileorder.CompileOrderViewInputConfigurator;
import ro.amiq.dvt.utils.DVTFileUtils;
import ro.amiq.dvt.utils.StringMatcher;
import ro.amiq.dvt.utils.parser.IDVTFileInstance;

public class CDTCompileOrderViewContributor
extends BaseCompileOrderViewContributor {
    private CompileOrderLabelProvider fLabelProvider = new CompileOrderLabelProvider();

    public LanguageKind getLanguageKind() {
        return LanguageKind.CPP;
    }

    public boolean adaptsTo(Object adapted) {
        return adapted instanceof RfTreeElementWrapper;
    }

    public void gotoElement(IProject project, Object wrapper) {
        try {
            if (!(wrapper instanceof RfTreeElementWrapper)) {
                return;
            }
            Object rfElement = ((RfTreeElementWrapper)((Object)wrapper)).getRfElement();
            if (rfElement instanceof RfDummyElement || rfElement instanceof CDTLanguageElement) {
                return;
            }
            if (!(rfElement instanceof CDTFileInstance)) {
                return;
            }
            IFile iFile = ((CDTFileInstance)rfElement).getFile(project);
            if (iFile.isAccessible()) {
                IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                IDE.openEditor((IWorkbenchPage)page, (IFile)iFile, (String)"org.eclipse.cdt.ui.editor.CEditor");
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    public boolean isSelectable(Object element, Object referenceData, StringMatcher matcher) {
        if (!(element instanceof RfTreeElementWrapper)) {
            return false;
        }
        Object rfElement = ((IDVTElementWrapper)element).getRfElement();
        if (rfElement == null) {
            return false;
        }
        if (rfElement instanceof CDTLanguageElement) {
            return false;
        }
        return matcher == null || ViewsUtils.matchCamelCaseOrRegex((StringMatcher)matcher, (String)this.fLabelProvider.getText(element));
    }

    public void gotoInclude(IProject project, IDVTElementWrapper wrapper) {
        try {
            if (!(wrapper.getRfElement() instanceof CDTFileInstance)) {
                return;
            }
            IDVTElementWrapper parentWrapper = wrapper.getParent();
            if (!(parentWrapper.getRfElement() instanceof CDTFileInstance)) {
                return;
            }
            CDTFileInstance parentFileInstance = (CDTFileInstance)parentWrapper.getRfElement();
            IFile parentIFile = parentFileInstance.getFile(project);
            IIndexFileLocation indexParentLocation = IndexLocationFactory.getWorkspaceIFL((IFile)parentIFile);
            IIndex projectIndex = CCorePlugin.getIndexManager().getIndex(CoreModel.getDefault().getCModel().getCProject(project.getName()));
            IIndexFile[] indexFilesForLocation = projectIndex.getFiles(indexParentLocation);
            if (indexFilesForLocation == null || indexFilesForLocation.length == 0) {
                return;
            }
            IIndexFile indexParentFile = null;
            IPath parentFullPath = parentIFile.getFullPath();
            if (parentFullPath == null) {
                return;
            }
            String parentFileFullPath = parentFullPath.toOSString();
            IIndexFile[] iIndexFileArray = indexFilesForLocation;
            int n = indexFilesForLocation.length;
            int n2 = 0;
            while (n2 < n) {
                IIndexFile indexFile = iIndexFileArray[n2];
                IIndexFileLocation indexFileLocation = indexFile.getLocation();
                if (indexFileLocation != null && parentFileFullPath.equals(indexFileLocation.getFullPath())) {
                    indexParentFile = indexFile;
                }
                ++n2;
            }
            if (indexParentFile == null) {
                return;
            }
            IIndexInclude includeDirective = null;
            CDTFileInstance fileInstance = (CDTFileInstance)wrapper.getRfElement();
            String fileFullPath = fileInstance.getFile(project).getFullPath().toOSString();
            IIndexInclude[] iIndexIncludeArray = indexParentFile.getIncludes();
            int n3 = iIndexIncludeArray.length;
            int n4 = 0;
            while (n4 < n3) {
                IIndexInclude include = iIndexIncludeArray[n4];
                String includeFullName = include.getFullName();
                if (includeFullName != null && !includeFullName.isEmpty() && fileFullPath.endsWith(includeFullName)) {
                    includeDirective = include;
                    break;
                }
                ++n4;
            }
            if (includeDirective == null) {
                return;
            }
            if (parentIFile.isAccessible()) {
                ITextEditor editor = (ITextEditor)IDE.openEditor((IWorkbenchPage)DVTUiUtils.getActivePage(), (IFile)parentIFile, (String)"org.eclipse.cdt.ui.editor.CEditor");
                if (editor == null) {
                    return;
                }
                editor.selectAndReveal(includeDirective.getNameOffset(), includeDirective.getNameLength());
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    public void gotoImport(IProject project, IDVTElementWrapper wrapper) {
    }

    public String getShortFileName(IDVTElementWrapper element) {
        Object rfElement = element.getRfElement();
        if (rfElement instanceof CDTFileInstance) {
            return ((CDTFileInstance)rfElement).getShortName();
        }
        return "";
    }

    public boolean canShowGotoIncludeMenu(IDVTElementWrapper element) {
        return element instanceof RfTreeElementWrapper && !(element.getRfElement() instanceof CDTLanguageElement) && !(element.getParent().getRfElement() instanceof CDTLanguageElement);
    }

    public boolean canShowGotoImportMenu(IDVTElementWrapper element) {
        return false;
    }

    public CompileOrderViewInput getInput(CompileOrderViewInputConfigurator configurator) {
        try {
            CompileOrderViewInput input = CompileOrderViewInput.emptyInput();
            IProject project = configurator.getProject();
            if (project == null || !project.isAccessible()) {
                return input;
            }
            if (!DVTNature.hasNature((IProject)project, (String)"ro.amiq.dvt.cdt.cppextnature")) {
                return input;
            }
            if (!DVTPlugin.getDefault().collect().c(project, "F6370705F657874")) {
                return input;
            }
            RfProject rfProject = RfManager.getInstance().getRfProject(project);
            if (rfProject == null || rfProject.getCompileRoot() == null) {
                return input;
            }
            RfTreeElementWrapper rootWrapper = new RfTreeElementWrapper();
            this.wrapFileInstances(rfProject.getCompileRoot(), rootWrapper, configurator, input);
            if (!rootWrapper.hasChildren()) {
                return CompileOrderViewInput.emptyInput();
            }
            StringMatcher[] searchSegments = configurator.getSearchSegments();
            ViewsUtils.hierarchicalSearch((IDVTElementWrapper)rootWrapper, (DVTBaseLabelProvider)this.fLabelProvider, (UpdateJob)configurator.getUpdateJob(), (StringMatcher[])searchSegments, (boolean[])configurator.getSearchStrictness());
            if (configurator.hasShowFilesWithErrors()) {
                RfTreeElementWrapper newRoot = new RfTreeElementWrapper();
                this.filterOutElementsWithoutErrors(rootWrapper, newRoot, configurator);
                List children = newRoot.getChildren();
                if (children != null) {
                    children.stream().forEach(e -> e.setAdditionalInfo(IDVTElementWrapper.Attribute.MATCH, true));
                    Collections.sort(children, (o1, o2) -> ((CDTFileInstance)o1.getRfElement()).getIndex() - ((CDTFileInstance)o2.getRfElement()).getIndex());
                } else {
                    newRoot.addChild(new RfTreeElementWrapper(new RfDummyElement(project.getName())));
                    newRoot.addChild(new RfTreeElementWrapper(new RfDummyElement("does not contain")));
                    newRoot.addChild(new RfTreeElementWrapper(new RfDummyElement("any C/C++ files with errors!")));
                }
                rootWrapper = newRoot;
            }
            if (configurator.hasShowFilesWithErrors() || searchSegments != null && searchSegments.length != 0) {
                this.countElements(rootWrapper, configurator, input);
                input.setTableInfo("[" + input.getNotFilteredElementCount() + "/" + input.getElementCount() + " total" + "]");
            } else {
                input.setNotFilteredElementCount(input.getElementCount());
                input.setTableInfo("[" + input.getElementCount() + " total" + "]");
            }
            if (input.getElementCount() == 0 || rootWrapper.getChildren() == null) {
                return CompileOrderViewInput.emptyInput();
            }
            List elements = input.getElements();
            if (configurator.isShowLanguageNameAsRootElement()) {
                RfTreeElementWrapper languageWrapper = new RfTreeElementWrapper(new CDTLanguageElement<String>(String.valueOf(LanguageKind.CPP.VIEW_NAME) + " " + input.getTableInfo()));
                languageWrapper.addChildren(rootWrapper.getChildren());
                elements.add(languageWrapper);
            } else {
                elements.addAll(rootWrapper.getChildren());
            }
            return input;
        }
        catch (Exception e2) {
            DVTLogger.INSTANCE.logError((Throwable)e2);
            return CompileOrderViewInput.emptyInput();
        }
    }

    private void filterOutElementsWithoutErrors(RfTreeElementWrapper root, RfTreeElementWrapper newRoot, CompileOrderViewInputConfigurator configurator) {
        List children = root.getChildren();
        CDTFileInstance rfElement = (CDTFileInstance)root.getRfElement();
        boolean hasErrors = false;
        if (rfElement != null) {
            boolean bl = hasErrors = DVTProblemDecorator.getHighestProblemSeverity((IResource)DVTFileUtils.getInstance().findProjectFile(configurator.getProject(), rfElement.getParserPath().path)) != -1;
        }
        if (children == null || children.isEmpty()) {
            if (hasErrors) {
                newRoot.addChild(root);
            }
            return;
        }
        Iterator iterator = children.iterator();
        while (iterator.hasNext()) {
            if (configurator.isCanceled()) {
                return;
            }
            RfTreeElementWrapper child = (RfTreeElementWrapper)((Object)iterator.next());
            this.filterOutElementsWithoutErrors(child, newRoot, configurator);
            iterator.remove();
        }
        if (hasErrors) {
            newRoot.addChild(root);
        }
    }

    private void wrapFileInstances(CDTFileInstance rootInstance, RfTreeElementWrapper rootWrapper, CompileOrderViewInputConfigurator configurator, CompileOrderViewInput input) {
        if (rootInstance.getChildren() == null) {
            return;
        }
        for (CDTFileInstance childInstance : rootInstance.getChildren()) {
            RfTreeElementWrapper childWrapper = new RfTreeElementWrapper(childInstance);
            childWrapper.setProject(configurator.getProject());
            String text = this.getLabelProvider((Object)childWrapper).getText((Object)childWrapper);
            DVTGUIFilterMatcher.ITextProvider textProvider = () -> text;
            if (DVTCompileOrderGUIFilterMatcher.filterElement((ViewSet.ViewName)ViewSet.ViewName.COMPILE_ORDER, (IProject)configurator.getProject(), (IDVTFileInstance)childInstance, (DVTGUIFilterMatcher.ITextProvider)textProvider) != DVTGUIFilterMatcher.GUIFilterResult.NOT_FILTERED) {
                if (!input.hasSearchedElementFiltered()) {
                    if (ViewsUtils.matchesPath((Object)((Object)childWrapper), (IRfFilterableTreeAccessor)configurator.getView())) {
                        input.setHasSearchedElementFiltered(true);
                    } else if (!childInstance.getChildren().isEmpty()) {
                        input.setHasSearchedElementFiltered(this.hasFilteredSearchedLocalMember(childInstance, configurator.getView()));
                    }
                }
                input.setHasGUIFilteredElements(true);
                continue;
            }
            rootWrapper.addChild(childWrapper);
            input.incrementElementCount();
            this.wrapFileInstances(childInstance, childWrapper, configurator, input);
        }
    }

    private boolean hasFilteredSearchedLocalMember(CDTFileInstance parentInstance, IRfFilterableTreeAccessor view) {
        List<CDTFileInstance> childInstances = parentInstance.getChildren();
        if (!childInstances.isEmpty()) {
            return false;
        }
        for (CDTFileInstance instance : childInstances) {
            if (ViewsUtilsCommon.matchesPath((Object)((Object)new RfTreeElementWrapper(instance)), (IRfFilterableTreeAccessor)view)) {
                return true;
            }
            if (!this.hasFilteredSearchedLocalMember(instance, view)) continue;
            return true;
        }
        return false;
    }

    public DVTBaseLabelProvider getLabelProvider(Object wrapper) {
        return this.fLabelProvider;
    }

    private void countElements(IDVTElementWrapper root, CompileOrderViewInputConfigurator configurator, CompileOrderViewInput input) {
        if (root == null) {
            return;
        }
        if (root.getRfElement() instanceof CDTFileInstance && root.getAdditionalInfo((Object)IDVTElementWrapper.Attribute.MATCH) != null) {
            input.incrementNotFilteredElementCount();
        }
        if (!root.hasChildren()) {
            return;
        }
        List children = root.getChildren();
        for (IDVTElementWrapper child : children) {
            if (configurator.isCanceled()) {
                return;
            }
            this.countElements(child, configurator, input);
        }
    }

    public String getComment(Object wrapper) {
        return null;
    }

    public List<ISymbolCollectorPrerequisite> getSymbolsPrerequisites(SymbolCollectorConfigurator configurator) {
        return null;
    }
}

