/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.cdt.model.reflection.views;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.regex.Pattern;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.browser.ITypeReference;
import org.eclipse.cdt.core.browser.IndexTypeInfo;
import org.eclipse.cdt.core.dom.IPDOMNode;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.index.IIndex;
import org.eclipse.cdt.core.index.IIndexBinding;
import org.eclipse.cdt.core.index.IIndexFile;
import org.eclipse.cdt.core.index.IIndexFileLocation;
import org.eclipse.cdt.core.index.IIndexMacro;
import org.eclipse.cdt.core.index.IIndexName;
import org.eclipse.cdt.core.index.IndexFilter;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.internal.core.CCoreInternals;
import org.eclipse.cdt.internal.core.index.IIndexFragmentBinding;
import org.eclipse.cdt.internal.core.index.IIndexFragmentName;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMMacro;
import org.eclipse.cdt.internal.ui.util.EditorUtility;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.ui.IEditorPart;
import ro.amiq.dvt.DVTPlugin;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.cdt.model.reflection.views.CDTLanguageElement;
import ro.amiq.dvt.cdt.model.reflection.views.MacroViewLabelProvider;
import ro.amiq.dvt.cdt.model.reflection.views.RfTreeElementWrapper;
import ro.amiq.dvt.cdt.ui.guifilters.CDTGUIFilterMatcher;
import ro.amiq.dvt.cdt.utils.CDTUtils;
import ro.amiq.dvt.core.DVTNature;
import ro.amiq.dvt.model.reflection.semantic.extension2.DummyElement;
import ro.amiq.dvt.model.reflection.views.IRfFilterableTreeAccessor;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.symbolcollector.ISymbolCollectorPrerequisite;
import ro.amiq.dvt.symbolcollector.SymbolCollectorConfigurator;
import ro.amiq.dvt.ui.guifilters.DVTGUIFilterMatcher;
import ro.amiq.dvt.ui.guifilters.ViewSet;
import ro.amiq.dvt.ui.views.DVTBaseLabelProvider;
import ro.amiq.dvt.ui.views.DVTViewManager;
import ro.amiq.dvt.ui.views.IDVTElementWrapper;
import ro.amiq.dvt.ui.views.ViewsUtils;
import ro.amiq.dvt.ui.views.lazy.views.macros.CDTMacroWrapper;
import ro.amiq.dvt.ui.views.lazy.views.macros.IMacrosViewContributor;
import ro.amiq.dvt.ui.views.lazy.views.macros.MacrosWrapper;
import ro.amiq.dvt.utils.StringMatcher;

public class CDTMacrosViewContributor
implements IMacrosViewContributor {
    private static final Pattern ANY_MATCH = Pattern.compile(".*");
    private static final Comparator<Object> MACROS_COMPARATOR = new Comparator<Object>(){

        @Override
        public int compare(Object o1, Object o2) {
            if (!(o1 instanceof CDTMacroWrapper) || !(o2 instanceof CDTMacroWrapper)) {
                return -1;
            }
            return ((IndexTypeInfo)((CDTMacroWrapper)o1).getRfElement()).getName().compareTo(((IndexTypeInfo)((CDTMacroWrapper)o2).getRfElement()).getName());
        }
    };
    private static final int MAX_CHARS_IN_MACRO_EXPANSION = 100;
    MacroViewLabelProvider labelProvider = new MacroViewLabelProvider();

    public LanguageKind getLanguageKind() {
        return LanguageKind.CPP;
    }

    public boolean adaptsTo(Object adapted) {
        return adapted instanceof CDTMacroWrapper || adapted instanceof CDTLanguageElement;
    }

    public DVTBaseLabelProvider getLabelProvider(Object wrapper) {
        return this.labelProvider;
    }

    public String getComment(Object wrapper) {
        return null;
    }

    public void gotoElement(IProject project, Object wrapper) {
        if (!(wrapper instanceof RfTreeElementWrapper)) {
            return;
        }
        Object rfElement = ((RfTreeElementWrapper)((Object)wrapper)).getRfElement();
        if (!(rfElement instanceof IndexTypeInfo)) {
            return;
        }
        try {
            ITypeReference location = ((IndexTypeInfo)rfElement).getResolvedReference();
            if (location == null) {
                return;
            }
            ICElement macroDef = CDTUtils.getMacroFromCElements(location.getCElements());
            if (macroDef == null) {
                return;
            }
            IEditorPart editor = EditorUtility.openInEditor((Object)macroDef);
            EditorUtility.revealInEditor((IEditorPart)editor, (ICElement)macroDef);
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    public boolean isSelectable(Object wrapper, Object referenceData, StringMatcher matcher) {
        return false;
    }

    public MacrosWrapper getLanguageMacrosWrapper(IProject project, IRfFilterableTreeAccessor view, IProgressMonitor monitor) {
        try {
            if (!DVTNature.hasNature((IProject)project, (String)"ro.amiq.dvt.cdt.cppextnature")) {
                return this.newEmptyMacrosWrapper();
            }
            if (!DVTPlugin.getDefault().collect().c(project, "F6370705F657874")) {
                return this.newEmptyMacrosWrapper();
            }
            if (!CCorePlugin.getIndexManager().isIndexerIdle()) {
                return this.newEmptyMacrosWrapper();
            }
            return this.computeMacrosWrapper(project, view);
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return this.newEmptyMacrosWrapper();
        }
    }

    private MacrosWrapper newEmptyMacrosWrapper() {
        return new MacrosWrapper(new CDTLanguageElement<String>(this.getLanguageKind().VIEW_NAME));
    }

    private MacrosWrapper computeMacrosWrapper(IProject project, IRfFilterableTreeAccessor view) throws CoreException {
        ICProject iCProject = CoreModel.getDefault().getCModel().getCProject(project.getName());
        if (iCProject == null) {
            return this.newEmptyMacrosWrapper();
        }
        IIndex index = CCoreInternals.getPDOMManager().getIndex(iCProject);
        try {
            index.acquireReadLock();
            IIndexBinding[] macroIndexBindings = index.findMacroContainers(ANY_MATCH, IndexFilter.ALL_DECLARED_OR_IMPLICIT, null);
            HashSet<IIndexBinding> handled = new HashSet<IIndexBinding>();
            LinkedHashMap<IndexTypeInfo, IIndexFragmentName> macrosToDeclarations = new LinkedHashMap<IndexTypeInfo, IIndexFragmentName>();
            IIndexBinding[] iIndexBindingArray = macroIndexBindings;
            int n = macroIndexBindings.length;
            int n2 = 0;
            while (n2 < n) {
                IIndexName[] bindingDeclarations;
                IIndexBinding binding = iIndexBindingArray[n2];
                if (binding != null && handled.add(binding) && (bindingDeclarations = index.findDeclarations((IBinding)binding)) != null && bindingDeclarations.length != 0) {
                    IIndexName[] iIndexNameArray = bindingDeclarations;
                    int n3 = bindingDeclarations.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IndexTypeInfo macroTypeInfo;
                        IIndexFragmentName declarationIndexName;
                        IIndexFragmentBinding macroBinding;
                        IIndexName declarationBinding = iIndexNameArray[n4];
                        if (declarationBinding instanceof IIndexFragmentName && (macroBinding = (declarationIndexName = (IIndexFragmentName)declarationBinding).getBinding()) instanceof PDOMMacro && macrosToDeclarations.get(macroTypeInfo = IndexTypeInfo.create((IIndex)index, (IIndexMacro)((PDOMMacro)macroBinding))) == null) {
                            macrosToDeclarations.put(macroTypeInfo, declarationIndexName);
                        }
                        ++n4;
                    }
                }
                ++n2;
            }
            index.releaseReadLock();
            index = null;
            MacrosWrapper result = this.newEmptyMacrosWrapper();
            TreeSet<Object> cdtMacros = new TreeSet<Object>(MACROS_COMPARATOR);
            for (Map.Entry entry : macrosToDeclarations.entrySet()) {
                this.wrap(project, cdtMacros, (IndexTypeInfo)entry.getKey(), (IIndexFragmentName)entry.getValue(), view, result);
            }
            result.getAllMacrosByCategory().put(new DummyElement("CDT_DEFAULT"), new ArrayList<Object>(cdtMacros));
            cdtMacros.clear();
            return result;
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            if (index != null) {
                index.releaseReadLock();
            }
            return this.newEmptyMacrosWrapper();
        }
    }

    private void wrap(IProject project, TreeSet<Object> cdtMacros, IndexTypeInfo macroTypeInfo, IIndexFragmentName macroDeclarationName, IRfFilterableTreeAccessor view, MacrosWrapper macrosWrapper) {
        try {
            IIndexFragmentBinding binding = macroDeclarationName.getBinding();
            if (!(binding instanceof PDOMMacro)) {
                return;
            }
            PDOMMacro macro = (PDOMMacro)binding;
            char[] macroExpansion = macro.getExpansion();
            CDTMacroWrapper rfElementWrapper = new CDTMacroWrapper((Object)macroTypeInfo);
            rfElementWrapper.setAdditionalInfo((Object)IDVTElementWrapper.Attribute.CDT_MACRO_EXPANSION, (Object)this.getWrappedMacroExpansion(macroExpansion));
            String fullPath = this.getFullPathFromIndexName(macroDeclarationName);
            if (fullPath != null) {
                String pathToElem = null;
                IFile resourceFile = ResourcesPlugin.getWorkspace().getRoot().getFile(Path.fromOSString((String)fullPath));
                IPath fileLocation = resourceFile.getLocation();
                if (fileLocation != null) {
                    pathToElem = fileLocation.toOSString();
                }
                List filters = DVTViewManager.getGuiFilters((IProject)project);
                if (pathToElem != null && CDTGUIFilterMatcher.filterElement((IPDOMNode)macro, pathToElem, filters, this.labelProvider.getText(macro), ViewSet.ViewName.MACRO, project) != DVTGUIFilterMatcher.GUIFilterResult.NOT_FILTERED) {
                    if (!macrosWrapper.hasSearchedElementFiltered() && ViewsUtils.matchesPath((Object)rfElementWrapper, (IRfFilterableTreeAccessor)view)) {
                        macrosWrapper.setHasSearchedElementFiltered(true);
                    }
                    macrosWrapper.setHasGUIFilteredElements(true);
                    return;
                }
            }
            macrosWrapper.incrementNofMacros();
            cdtMacros.add(rfElementWrapper);
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    private String getWrappedMacroExpansion(char[] expansion) {
        if (expansion == null || expansion.length == 0) {
            return "";
        }
        char[] expansionChars = Arrays.copyOfRange(expansion, 0, Math.min(100, expansion.length));
        return new String(expansionChars);
    }

    private String getFullPathFromIndexName(IIndexFragmentName indexName) throws CoreException {
        if (indexName == null) {
            return null;
        }
        IIndexFile indexFile = indexName.getFile();
        if (indexFile == null) {
            return null;
        }
        IIndexFileLocation indexFilelocation = indexFile.getLocation();
        if (indexFilelocation == null) {
            return null;
        }
        return indexFilelocation.getFullPath();
    }

    public List<ISymbolCollectorPrerequisite> getSymbolsPrerequisites(SymbolCollectorConfigurator inputSourceConfigurator) {
        return null;
    }
}

