/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.cdt.model.reflection.views;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.dom.ILinkage;
import org.eclipse.cdt.core.dom.IPDOMNode;
import org.eclipse.cdt.core.dom.IPDOMVisitor;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.ITypedef;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPNamespace;
import org.eclipse.cdt.core.index.IIndexFile;
import org.eclipse.cdt.core.index.IIndexFileLocation;
import org.eclipse.cdt.core.index.IIndexName;
import org.eclipse.cdt.core.index.IndexLocationFactory;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.internal.core.CCoreInternals;
import org.eclipse.cdt.internal.core.pdom.IPDOM;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMBinding;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMLinkage;
import org.eclipse.cdt.internal.ui.indexview.IndexLabelProvider;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.texteditor.ITextEditor;
import ro.amiq.dvt.DVTPlugin;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.cdt.model.reflection.views.CDTLanguageElement;
import ro.amiq.dvt.cdt.model.reflection.views.RfTreeElementWrapper;
import ro.amiq.dvt.cdt.model.reflection.views.TypesViewLabelProvider;
import ro.amiq.dvt.cdt.ui.guifilters.CDTGUIFilterMatcher;
import ro.amiq.dvt.cdt.utils.CDTUtils;
import ro.amiq.dvt.core.DVTNature;
import ro.amiq.dvt.model.reflection.IRfKind;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.views.IRfFilterableTreeAccessor;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.symbolcollector.ISymbolCollectorPrerequisite;
import ro.amiq.dvt.symbolcollector.SymbolCollectorConfigurator;
import ro.amiq.dvt.ui.guifilters.DVTGUIFilterMatcher;
import ro.amiq.dvt.ui.guifilters.ViewSet;
import ro.amiq.dvt.ui.views.ComplexFilter;
import ro.amiq.dvt.ui.views.DVTBaseLabelProvider;
import ro.amiq.dvt.ui.views.DVTViewManager;
import ro.amiq.dvt.ui.views.IDVTElementWrapper;
import ro.amiq.dvt.ui.views.IMembersLabelProvider;
import ro.amiq.dvt.ui.views.MembersViewInput;
import ro.amiq.dvt.ui.views.ViewsUtils;
import ro.amiq.dvt.ui.views.ViewsUtilsCommon;
import ro.amiq.dvt.ui.views.lazy.views.types.BaseTypesViewContributor;
import ro.amiq.dvt.ui.views.lazy.views.types.TypesViewInput;
import ro.amiq.dvt.ui.views.lazy.views.types.TypesViewInputConfigurator;
import ro.amiq.dvt.utils.StringMatcher;

public class CDTTypesViewContributor
extends BaseTypesViewContributor {
    private static Map<RfTreeElementWrapper, ArrayList<IDVTElementWrapper>> fMembersMap = new HashMap<RfTreeElementWrapper, ArrayList<IDVTElementWrapper>>();
    private static final Boolean DISABLE_SHOW_ANON_UNDER_ALIASES = false;

    public CDTTypesViewContributor() {
        super((DVTBaseLabelProvider)new TypesViewLabelProvider(), (IMembersLabelProvider)new TypesViewLabelProvider());
    }

    public TypesViewInput getInput(TypesViewInputConfigurator inputConfigurator) {
        fMembersMap.clear();
        TypesViewInput input = TypesViewInput.emptyInput();
        IProject project = inputConfigurator.getProject();
        if (project == null) {
            return input;
        }
        if (!DVTNature.hasNature((IProject)project, (String)"ro.amiq.dvt.cdt.cppextnature")) {
            return input;
        }
        if (!DVTPlugin.getDefault().collect().c(project, "F6370705F657874")) {
            return input;
        }
        if (!CCorePlugin.getIndexManager().isIndexerIdle()) {
            return input;
        }
        RfTreeElementWrapper rootWrapper = new RfTreeElementWrapper();
        rootWrapper.setProject(project);
        try {
            this.computeChildren(rootWrapper, inputConfigurator, input);
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        if ((rootWrapper.getChildren() == null || ((ArrayList)rootWrapper.getChildren()).isEmpty()) && (fMembersMap.get((Object)rootWrapper) == null || fMembersMap.get((Object)rootWrapper).isEmpty())) {
            return TypesViewInput.emptyInput();
        }
        String labelInfo = "";
        int nofFilteredTypes = this.filterTree(rootWrapper, inputConfigurator);
        if (nofFilteredTypes != -1) {
            labelInfo = "[" + nofFilteredTypes + "/" + input.getNrTypes() + " types" + "]";
            input.setNrNotFilteredTypes(nofFilteredTypes);
        } else {
            labelInfo = "[" + input.getNrTypes() + " types" + "]";
        }
        RfTreeElementWrapper langRoot = new RfTreeElementWrapper(new CDTLanguageElement<String>(String.valueOf(LanguageKind.CPP.VIEW_NAME) + " " + labelInfo));
        langRoot.addChildren(rootWrapper.getChildren());
        fMembersMap.put(langRoot, fMembersMap.get((Object)rootWrapper));
        fMembersMap.remove((Object)rootWrapper);
        rootWrapper = langRoot;
        input.setElements(Arrays.asList(new IDVTElementWrapper[]{rootWrapper}));
        return input;
    }

    private int filterTree(RfTreeElementWrapper root, TypesViewInputConfigurator viewConfigurator) {
        if (root == null || viewConfigurator == null) {
            return -1;
        }
        if (!viewConfigurator.getView().isFiltered()) {
            return -1;
        }
        ComplexFilter filter = new ComplexFilter(viewConfigurator.getView(), true){

            public boolean shouldSkipCount(IDVTElementWrapper node) {
                if (!(node.getRfElement() instanceof IPDOMNode)) {
                    return true;
                }
                return CDTTypesViewContributor.this.shouldSkipCount((IPDOMNode)node.getRfElement());
            }
        };
        ViewsUtils.filterElementComplex((IDVTElementWrapper)root, (ComplexFilter)filter, (IProgressMonitor)viewConfigurator.getMonitor());
        return filter.matchCount;
    }

    public MembersViewInput getMembersInput(Object element, StringMatcher stringMatcher) {
        ArrayList<IDVTElementWrapper> members = fMembersMap.get(element);
        if (members == null || !(element instanceof RfTreeElementWrapper)) {
            return new MembersViewInput(Collections.emptyList(), false);
        }
        boolean hasGUIFilteredMembers = false;
        IProject project = ((RfTreeElementWrapper)((Object)element)).getProject();
        List filters = DVTViewManager.getGuiFilters((IProject)project);
        ArrayList<IDVTElementWrapper> result = new ArrayList<IDVTElementWrapper>();
        for (IDVTElementWrapper wrapper : members) {
            RfTreeElementWrapper rfWrapper = (RfTreeElementWrapper)wrapper;
            if (!(rfWrapper.getRfElement() instanceof IPDOMNode)) continue;
            IPDOMNode ipdomNode = (IPDOMNode)rfWrapper.getRfElement();
            String pathToElem = null;
            try {
                IIndexName indexName = CDTUtils.indexNameFromPDOMNode(ipdomNode);
                pathToElem = this.getFullPathFromIndexName(indexName);
            }
            catch (CoreException e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
                continue;
            }
            if (pathToElem != null && CDTGUIFilterMatcher.filterElement(ipdomNode, pathToElem, filters, IndexLabelProvider.getText((IPDOMNode)ipdomNode), ViewSet.ViewName.TYPES, project) != DVTGUIFilterMatcher.GUIFilterResult.NOT_FILTERED) {
                hasGUIFilteredMembers = true;
                continue;
            }
            if (!ViewsUtils.matchCamelCaseOrRegex((StringMatcher)stringMatcher, (String)wrapper.toString())) continue;
            result.add(wrapper);
        }
        return new MembersViewInput(result, hasGUIFilteredMembers);
    }

    private String getFullPathFromIndexName(IIndexName indexName) throws CoreException {
        if (indexName == null) {
            return null;
        }
        IIndexFile indexFile = indexName.getFile();
        if (indexFile == null) {
            return null;
        }
        IIndexFileLocation indexFilelocation = indexFile.getLocation();
        if (indexFilelocation == null) {
            return null;
        }
        return indexFilelocation.getFullPath();
    }

    public void gotoSelectedMember(IProject project, IDVTElementWrapper element) {
        this.gotoElement(project, element);
    }

    public LanguageKind getLanguageKind() {
        return LanguageKind.CPP;
    }

    public boolean adaptsTo(Object adapted) {
        return adapted instanceof RfTreeElementWrapper;
    }

    public void gotoElement(IProject project, Object wrapper) {
        try {
            if (!(wrapper instanceof RfTreeElementWrapper)) {
                return;
            }
            RfTreeElementWrapper rfWrapper = (RfTreeElementWrapper)((Object)wrapper);
            if (!(rfWrapper.getRfElement() instanceof IPDOMNode)) {
                return;
            }
            this.showInEditor(CDTUtils.indexNameFromPDOMNode((IPDOMNode)rfWrapper.getRfElement()));
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    private void showInEditor(IIndexName name) throws CModelException, PartInitException, CoreException {
        if (name == null) {
            return;
        }
        IPath path = IndexLocationFactory.getPath((IIndexFileLocation)name.getFile().getLocation());
        if (path == null) {
            return;
        }
        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        IFile iFile = ResourcesPlugin.getWorkspace().getRoot().getFile(path);
        if (!iFile.isAccessible()) {
            return;
        }
        ITextEditor editor = (ITextEditor)IDE.openEditor((IWorkbenchPage)page, (IFile)iFile, (String)"org.eclipse.cdt.ui.editor.CEditor");
        if (editor == null) {
            return;
        }
        int nodeOffset = name.getNodeOffset();
        int nodeLength = name.getNodeLength();
        try {
            if (nodeLength == -1) {
                IDocument document = editor.getDocumentProvider().getDocument((Object)editor.getEditorInput());
                nodeOffset = document.getLineOffset(nodeOffset);
                nodeLength = document.getLineLength(nodeOffset);
            }
            editor.selectAndReveal(nodeOffset, nodeLength);
        }
        catch (BadLocationException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    public boolean isSelectable(Object element, Object referenceData, StringMatcher matcher) {
        if (!(element instanceof RfTreeElementWrapper)) {
            return false;
        }
        Object rfElement = ((IDVTElementWrapper)element).getRfElement();
        if (rfElement == null) {
            return false;
        }
        if (rfElement instanceof CDTLanguageElement) {
            return false;
        }
        return matcher == null || ViewsUtils.matchCamelCaseOrRegex((StringMatcher)matcher, (String)this.getLabelProvider(element).getText(element));
    }

    protected IRfKind getKind(IRfNamedElement e) {
        return null;
    }

    private void computeChildren(RfTreeElementWrapper rootWrapper, TypesViewInputConfigurator configurator, TypesViewInput input) throws CoreException, InterruptedException {
        ICProject cproject = CoreModel.getDefault().getCModel().getCProject(configurator.getProject().getName());
        if (cproject == null) {
            return;
        }
        IPDOM pdom = CCoreInternals.getPDOMManager().getPDOM(cproject);
        pdom.acquireReadLock();
        HashMap<String, RfTreeElementWrapper> anonymousTypes = new HashMap<String, RfTreeElementWrapper>();
        LinkedHashMap<RfTreeElementWrapper, String> typedefsToAnonymousTypes = new LinkedHashMap<RfTreeElementWrapper, String>();
        try {
            PDOMLinkage[] pDOMLinkageArray = pdom.getLinkageImpls();
            int n = pDOMLinkageArray.length;
            int n2 = 0;
            while (n2 < n) {
                PDOMLinkage ipdomNode = pDOMLinkageArray[n2];
                this.wrap(rootWrapper, (IPDOMNode)ipdomNode, anonymousTypes, typedefsToAnonymousTypes, configurator, input);
                ++n2;
            }
            if (!DISABLE_SHOW_ANON_UNDER_ALIASES.booleanValue()) {
                this.migrateAnonTypesUnderAliases(anonymousTypes, typedefsToAnonymousTypes);
            }
        }
        finally {
            pdom.releaseReadLock();
        }
    }

    private void migrateAnonTypesUnderAliases(Map<String, RfTreeElementWrapper> anonymousTypes, Map<RfTreeElementWrapper, String> typedefsToAnonymousTypes) {
        HashSet swappedAnonymousWrappers = new HashSet();
        ArrayList<RfTreeElementWrapper> reversedKeySet = new ArrayList<RfTreeElementWrapper>(typedefsToAnonymousTypes.keySet());
        Collections.reverse(reversedKeySet);
        reversedKeySet.forEach(typedefWrapper -> {
            if (typedefWrapper.hasChildren()) {
                return;
            }
            ArrayList<IDVTElementWrapper> members = fMembersMap.get(typedefWrapper);
            if (members != null && !members.isEmpty()) {
                return;
            }
            String hash = (String)typedefsToAnonymousTypes.get(typedefWrapper);
            RfTreeElementWrapper swap = (RfTreeElementWrapper)((Object)((Object)anonymousTypes.get(hash)));
            if (swap == null) {
                return;
            }
            swappedAnonymousWrappers.add(swap);
            typedefWrapper.addChildren(this.clone(swap.getChildren(), swappedAnonymousWrappers));
            fMembersMap.put((RfTreeElementWrapper)((Object)typedefWrapper), (ArrayList)this.clone((List)fMembersMap.get((Object)swap), swappedAnonymousWrappers));
        });
        swappedAnonymousWrappers.forEach(anonWrapper -> {
            RfTreeElementWrapper parent = anonWrapper.getParent();
            if (parent == null) {
                return;
            }
            parent.removeChild((IDVTElementWrapper)anonWrapper);
        });
    }

    private <T extends IDVTElementWrapper> List<T> clone(List<T> children, Set<RfTreeElementWrapper> swappedAnonymousWrappers) {
        if (children == null) {
            return null;
        }
        ArrayList result = new ArrayList(children.size());
        children.forEach(child -> {
            RfTreeElementWrapper childClone = new RfTreeElementWrapper(child.getRfElement());
            childClone.addChildren(this.clone(child.getChildren(), swappedAnonymousWrappers));
            fMembersMap.put(childClone, fMembersMap.get(child));
            if (swappedAnonymousWrappers.contains(child)) {
                swappedAnonymousWrappers.add(childClone);
            }
            result.add(childClone);
        });
        return result;
    }

    private boolean shouldSkipCount(IPDOMNode el) {
        return el instanceof ICPPNamespace || el instanceof PDOMLinkage;
    }

    private void wrap(RfTreeElementWrapper rootWrapper, IPDOMNode ipdomNode, Map<String, RfTreeElementWrapper> anonymousTypes, Map<RfTreeElementWrapper, String> typedefsToAnonymousTypes, TypesViewInputConfigurator configurator, TypesViewInput input) {
        RfTreeElementWrapper rfElementWrapper;
        IProject project;
        block31: {
            if (rootWrapper == null) {
                return;
            }
            IIndexName indexName = CDTUtils.indexNameFromPDOMNode(ipdomNode);
            if (ipdomNode instanceof PDOMBinding && indexName == null) {
                return;
            }
            project = rootWrapper.getProject();
            if (project == null) {
                return;
            }
            rfElementWrapper = new RfTreeElementWrapper(ipdomNode);
            rfElementWrapper.setProject(project);
            if (!DISABLE_SHOW_ANON_UNDER_ALIASES.booleanValue()) {
                IType aliasedTo;
                if (this.isAnonymousType(ipdomNode)) {
                    anonymousTypes.put(this.hash(ipdomNode), rfElementWrapper);
                } else if (ipdomNode instanceof ITypedef && (aliasedTo = ((ITypedef)ipdomNode).getType()) instanceof IPDOMNode && this.isAnonymousType((IPDOMNode)aliasedTo)) {
                    typedefsToAnonymousTypes.put(rfElementWrapper, this.hash((IPDOMNode)aliasedTo));
                }
            }
            IRfFilterableTreeAccessor view = configurator.getView();
            if (indexName != null) {
                try {
                    String fullPath = this.getFullPathFromIndexName(indexName);
                    if (fullPath == null) break block31;
                    String pathToElem = null;
                    IFile resourceFile = ResourcesPlugin.getWorkspace().getRoot().getFile(Path.fromOSString((String)fullPath));
                    IPath fileLocation = resourceFile.getLocation();
                    if (fileLocation != null) {
                        pathToElem = fileLocation.toOSString();
                    }
                    List filters = DVTViewManager.getGuiFilters((IProject)project);
                    if (pathToElem != null && CDTGUIFilterMatcher.filterElement(ipdomNode, pathToElem, filters, this.getLabelProvider((Object)rfElementWrapper).getText((Object)ipdomNode), ViewSet.ViewName.TYPES, project) != DVTGUIFilterMatcher.GUIFilterResult.NOT_FILTERED) {
                        if (!input.isSearchedElementFiltered()) {
                            if (ViewsUtilsCommon.matchesPath((Object)((Object)rfElementWrapper), (IRfFilterableTreeAccessor)view)) {
                                input.setSearchedElementFiltered(true);
                            } else {
                                ChildrenCollector collector = new ChildrenCollector();
                                ipdomNode.accept((IPDOMVisitor)collector);
                                if (!collector.getNodes().isEmpty()) {
                                    input.setSearchedElementFiltered(this.hasFilteredSearchedLocalMember(ipdomNode, view));
                                }
                            }
                        }
                        input.setHasGUIFilteredElements(true);
                        return;
                    }
                }
                catch (Exception e) {
                    DVTLogger.INSTANCE.logError((Throwable)e);
                }
            } else {
                List filters = DVTViewManager.getGuiFilters((IProject)project);
                if (CDTGUIFilterMatcher.filterElement(ipdomNode, null, filters, this.getLabelProvider((Object)rfElementWrapper).getText((Object)ipdomNode), ViewSet.ViewName.TYPES, project) != DVTGUIFilterMatcher.GUIFilterResult.NOT_FILTERED) {
                    if (!input.isSearchedElementFiltered()) {
                        if (ViewsUtilsCommon.matchesPath((Object)((Object)rfElementWrapper), (IRfFilterableTreeAccessor)view)) {
                            input.setSearchedElementFiltered(true);
                        } else {
                            try {
                                ChildrenCollector collector = new ChildrenCollector();
                                ipdomNode.accept((IPDOMVisitor)collector);
                                if (!collector.getNodes().isEmpty()) {
                                    input.setSearchedElementFiltered(this.hasFilteredSearchedLocalMember(ipdomNode, view));
                                }
                            }
                            catch (CoreException e) {
                                DVTLogger.INSTANCE.logError((Throwable)e);
                            }
                        }
                    }
                    input.setHasGUIFilteredElements(true);
                    return;
                }
            }
        }
        if (!this.shouldSkipCount(ipdomNode)) {
            input.incrementNrTypes();
        }
        rootWrapper.addChild(rfElementWrapper);
        try {
            ChildrenCollector collector = new ChildrenCollector();
            ipdomNode.accept((IPDOMVisitor)collector);
            ArrayList<RfTreeElementWrapper> memberWrappers = new ArrayList<RfTreeElementWrapper>();
            for (IPDOMNode childNode : collector.getNodes()) {
                if (configurator.isCanceled()) {
                    return;
                }
                if (!this.isMember(childNode)) {
                    this.wrap(rfElementWrapper, childNode, anonymousTypes, typedefsToAnonymousTypes, configurator, input);
                    continue;
                }
                RfTreeElementWrapper memberWrapper = new RfTreeElementWrapper(childNode);
                memberWrapper.setProject(project);
                memberWrappers.add(memberWrapper);
            }
            if (!memberWrappers.isEmpty()) {
                fMembersMap.put(rfElementWrapper, memberWrappers);
            }
        }
        catch (CoreException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    private boolean hasFilteredSearchedLocalMember(IPDOMNode parentElement, IRfFilterableTreeAccessor view) {
        ChildrenCollector collector = new ChildrenCollector();
        try {
            parentElement.accept((IPDOMVisitor)collector);
        }
        catch (CoreException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return false;
        }
        List<IPDOMNode> childElements = collector.getNodes();
        if (childElements.isEmpty()) {
            return false;
        }
        for (IPDOMNode element : childElements) {
            if (ViewsUtilsCommon.matchesPath((Object)((Object)new RfTreeElementWrapper(element)), (IRfFilterableTreeAccessor)view)) {
                return true;
            }
            if (!this.hasFilteredSearchedLocalMember(element, view)) continue;
            return true;
        }
        return false;
    }

    private String hash(IPDOMNode ipdomNode) {
        return IndexLabelProvider.getText((IPDOMNode)ipdomNode);
    }

    private boolean getAssociatedType(IPDOMNode node) {
        if (!(node instanceof ITypedef)) {
            return false;
        }
        IType aliasedTo = ((ITypedef)node).getType();
        if (!(aliasedTo instanceof IPDOMNode)) {
            return false;
        }
        return this.isAnonymousType((IPDOMNode)aliasedTo);
    }

    private boolean isAnonymousType(IPDOMNode node) {
        String text = IndexLabelProvider.getText((IPDOMNode)node);
        return text.startsWith("{") && text.endsWith("}");
    }

    private boolean isMember(Object element) {
        if (element instanceof ICPPClassType) {
            switch (((ICPPClassType)element).getKey()) {
                case 3: {
                    return false;
                }
                case 1: {
                    return false;
                }
                case 2: {
                    return false;
                }
            }
        }
        if (element instanceof IType) {
            return false;
        }
        if (element instanceof ICPPNamespace) {
            return false;
        }
        return !(element instanceof ILinkage);
    }

    public IRfKind getKind(String rfKindValue) {
        return null;
    }

    public List<ISymbolCollectorPrerequisite> getSymbolsPrerequisites(SymbolCollectorConfigurator configurator) {
        return null;
    }

    private static class ChildrenCollector
    implements IPDOMVisitor {
        private ArrayList<IPDOMNode> fNodes = new ArrayList();

        public boolean visit(IPDOMNode node) throws CoreException {
            this.fNodes.add(node);
            return false;
        }

        public void leave(IPDOMNode node) throws CoreException {
        }

        public List<IPDOMNode> getNodes() {
            return this.fNodes;
        }
    }
}

