/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.cdt.nature;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.cdt.build.core.scannerconfig.ScannerConfigBuilder;
import org.eclipse.cdt.build.core.scannerconfig.ScannerConfigNature;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.language.settings.providers.ILanguageSettingsProvider;
import org.eclipse.cdt.core.language.settings.providers.ILanguageSettingsProvidersKeeper;
import org.eclipse.cdt.core.language.settings.providers.LanguageSettingsManager;
import org.eclipse.cdt.core.language.settings.providers.ScannerDiscoveryLegacySupport;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.core.settings.model.ICProjectDescription;
import org.eclipse.cdt.core.settings.model.ICProjectDescriptionManager;
import org.eclipse.cdt.internal.core.LocalProjectScope;
import org.eclipse.cdt.internal.core.model.CModelManager;
import org.eclipse.cdt.managedbuilder.core.IBuilder;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IManagedBuildInfo;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.managedbuilder.core.ManagedCProjectNature;
import org.eclipse.cdt.managedbuilder.internal.core.PropertyManager;
import org.eclipse.cdt.managedbuilder.language.settings.providers.AbstractBuiltinSpecsDetector;
import org.eclipse.cdt.utils.cdtvariables.CdtVariableResolver;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IMarkerDelta;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Platform;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;
import ro.amiq.dvt.DVTEclipseCDTUtils;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.core.DVTNature;
import ro.amiq.dvt.nature.INatureContributor;
import ro.amiq.dvt.nature.NatureContributors;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.utils.DVTUtilsCommon;

public class CPPNatureContributor
implements INatureContributor {
    public String getName() {
        return LanguageKind.CPP.LONG_NAME;
    }

    public String getLangName() {
        return LanguageKind.CPP.toString();
    }

    public LanguageKind getLanguageKind() {
        return LanguageKind.CPP;
    }

    public boolean hasNature(IProject project) {
        if (!project.isAccessible()) {
            return false;
        }
        boolean result = false;
        try {
            result = project.hasNature("org.eclipse.cdt.core.cnature") && project.hasNature(LanguageKind.VLOG.NATURE_ID) || project.hasNature(LanguageKind.CPP.NATURE_ID);
        }
        catch (CoreException coreException) {
            result = false;
        }
        return result;
    }

    public void activateNature(IProject project) {
        try {
            NullProgressMonitor pm = new NullProgressMonitor();
            DVTNature.addNature((IProject)project, (String)LanguageKind.CPP.NATURE_ID, (IProgressMonitor)pm);
            CCorePlugin.getDefault().createCDTProject(project.getDescription(), project, (IProgressMonitor)pm);
            CCorePlugin.getDefault().convertProjectFromCtoCC(project, (IProgressMonitor)pm);
            ICProjectDescriptionManager manager = CCorePlugin.getDefault().getProjectDescriptionManager();
            ICProjectDescription projectDescription = manager.getProjectDescription(project, 4);
            if (projectDescription != null) {
                return;
            }
            projectDescription = manager.createProjectDescription(project, false);
            ICConfigurationDescription base = CCorePlugin.getDefault().getPreferenceConfiguration("org.eclipse.cdt.managedbuilder.core.configurationDataProvider");
            ICConfigurationDescription configDescription = projectDescription.createConfiguration(ManagedBuildManager.calculateChildId((String)"0", null), "Default", base);
            IConfiguration configuration = ManagedBuildManager.getConfigurationForDescription((ICConfigurationDescription)configDescription);
            configuration.setArtifactName(CdtVariableResolver.createVariableReference((String)"ProjName"));
            configuration.setBuildCommand("");
            configuration.setBuildArguments("");
            configuration.setCleanCommand("");
            IBuilder builder = configuration.getEditableBuilder();
            builder.setCommand("");
            builder.setManagedBuildOn(false);
            builder.setAutoBuildEnable(false);
            builder.setCleanBuildEnable(false);
            builder.setFullBuildEnable(false);
            builder.setIncrementalBuildEnable(false);
            CPPNatureContributor.setLanguageProviders(configDescription, null, null);
            projectDescription.setDefaultSettingConfiguration(configDescription);
            projectDescription.setActiveConfiguration(configDescription);
            manager.setProjectDescription(project, projectDescription);
            projectDescription.setReadOnly(true, true);
            CPPNatureContributor.removeNatures(project, ScannerConfigNature.NATURE_ID);
            ScannerDiscoveryLegacySupport.setLanguageSettingsProvidersFunctionalityEnabled((IProject)project, (boolean)true);
            Preferences codanPreferences = Platform.getPreferencesService().getRootNode().node("project").node(project.getName()).node("org.eclipse.cdt.codan.core");
            codanPreferences.putBoolean("onBuild", false);
            codanPreferences.putBoolean("inEditor", false);
            codanPreferences.putBoolean("useParentScope", false);
            codanPreferences.put("org.eclipse.cdt.codan.internal.checkers.CaseBreakProblem", "-Warning");
            codanPreferences.put("org.eclipse.cdt.codan.internal.checkers.CatchByReference", "-Warning");
            codanPreferences.put("org.eclipse.cdt.codan.internal.checkers.SuspiciousSemicolonProblem", "-Warning");
            codanPreferences.put("org.eclipse.cdt.codan.internal.checkers.UnusedFunctionDeclarationProblem", "-Warning");
            codanPreferences.put("org.eclipse.cdt.codan.internal.checkers.UnusedStaticFunctionProblem", "-Warning");
            codanPreferences.put("org.eclipse.cdt.codan.internal.checkers.UnusedVariableDeclarationProblem", "-Warning");
            try {
                codanPreferences.flush();
            }
            catch (BackingStoreException e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
            }
        }
        catch (CoreException | OperationCanceledException e) {
            DVTLogger.INSTANCE.logError(e);
        }
    }

    public static void setLanguageProviders(ICConfigurationDescription configDescription, String gccPath, String gccArgs) {
        ILanguageSettingsProvider gccProvider = null;
        ILanguageSettingsProvider dvtProvider = null;
        String newGccCommand = null;
        boolean needToUpdateGccCommand = false;
        List providers = ((ILanguageSettingsProvidersKeeper)configDescription).getLanguageSettingProviders();
        for (ILanguageSettingsProvider provider : providers) {
            if ("ro.amiq.dvt.cdt.provider.DVTGCCBuiltinSpecsDetector".equals(provider.getId())) {
                gccProvider = provider;
                String command = ((AbstractBuiltinSpecsDetector)gccProvider).getCommand();
                if (command == null || command.trim().isEmpty() || command.indexOf("${FLAGS}") < 0) {
                    command = "gcc ${FLAGS} -E -P -v -dD \"${INPUTS}\"";
                }
                String newGccPathAndArgs = (String.valueOf(gccPath == null ? "gcc" : gccPath.trim()) + " " + (gccArgs == null ? "" : gccArgs.trim())).trim();
                int position = command.indexOf("${FLAGS}");
                needToUpdateGccCommand = !command.substring(0, position).trim().equals(newGccPathAndArgs);
                newGccCommand = String.valueOf(newGccPathAndArgs) + " " + command.substring(position);
                continue;
            }
            if (!"ro.amiq.dvt.cdt.provider.DVTBuildSettingsProvider".equals(provider.getId())) continue;
            dvtProvider = provider;
        }
        if (gccProvider != null && dvtProvider != null && !needToUpdateGccCommand) {
            return;
        }
        if (gccProvider == null || needToUpdateGccCommand) {
            gccProvider = LanguageSettingsManager.getExtensionProviderCopy((String)"ro.amiq.dvt.cdt.provider.DVTGCCBuiltinSpecsDetector", (boolean)false);
            ((AbstractBuiltinSpecsDetector)gccProvider).setCommand(newGccCommand != null ? newGccCommand : "gcc ${FLAGS} -E -P -v -dD \"${INPUTS}\"");
        }
        if (dvtProvider == null) {
            dvtProvider = LanguageSettingsManager.getWorkspaceProvider((String)"ro.amiq.dvt.cdt.provider.DVTBuildSettingsProvider");
        }
        ((ILanguageSettingsProvidersKeeper)configDescription).setLanguageSettingProviders(Arrays.asList(gccProvider, dvtProvider));
    }

    private static void removeNatures(IProject project, String ... naturesToRemove) throws CoreException {
        IProjectDescription description = project.getDescription();
        String[] natureIds = description.getNatureIds();
        int k = 0;
        int i = 0;
        while (i < natureIds.length) {
            String natureId = natureIds[i];
            if (CPPNatureContributor.indexOf(natureId, naturesToRemove) < 0) {
                natureIds[k++] = natureId;
            }
            ++i;
        }
        if (k < natureIds.length) {
            description.setNatureIds(Arrays.copyOf(natureIds, k));
            project.setDescription(description, null);
        }
    }

    private static <T, U extends T> int indexOf(U obj, T[] array) {
        int i = 0;
        while (i < array.length) {
            if (obj == array[i] || obj != null && obj.equals(array[i])) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public void deactivateNature(final IProject project) {
        try {
            NullProgressMonitor monitor;
            block14: {
                INatureContributor cppExtContributor = NatureContributors.getContributor((LanguageKind)LanguageKind.CPP_EXT);
                if (cppExtContributor != null && cppExtContributor.hasNature(project)) {
                    cppExtContributor.deactivateNature(project);
                }
                DVTNature.removeNature((IProject)project, (String)LanguageKind.CPP.NATURE_ID, null);
                IManagedBuildInfo info = ManagedBuildManager.getBuildInfo((IResource)project);
                if (info != null) {
                    PropertyManager.getInstance().clearProperties(info.getManagedProject());
                }
                LocalProjectScope.deletePreferences((IPath)project.getFullPath(), null);
                CModelManager.getDefault().resourceChanged(new IResourceChangeEvent(){

                    public int getType() {
                        return 4;
                    }

                    public IResource getResource() {
                        return project;
                    }

                    public Object getSource() {
                        return ResourcesPlugin.getWorkspace();
                    }

                    public IMarkerDelta[] findMarkerDeltas(String type, boolean includeSubtypes) {
                        return null;
                    }

                    public int getBuildKind() {
                        return 0;
                    }

                    public IResourceDelta getDelta() {
                        return null;
                    }
                });
                monitor = new NullProgressMonitor();
                IProjectDescription description = project.getDescription();
                ICommand[] oldBuildSpecs = description.getBuildSpec();
                if (oldBuildSpecs != null) {
                    LinkedList<ICommand> newBuildSpecs = new LinkedList<ICommand>();
                    ICommand[] iCommandArray = oldBuildSpecs;
                    int n = oldBuildSpecs.length;
                    int n2 = 0;
                    while (n2 < n) {
                        ICommand buildSpec = iCommandArray[n2];
                        if (!ScannerConfigBuilder.BUILDER_ID.equals(buildSpec.getBuilderName())) {
                            newBuildSpecs.add(buildSpec);
                        }
                        ++n2;
                    }
                    description.setBuildSpec(newBuildSpecs.toArray(new ICommand[newBuildSpecs.size()]));
                    project.setDescription(description, (IProgressMonitor)monitor);
                }
                String path = String.valueOf(project.getLocation().toOSString()) + "/.project";
                DVTEclipseCDTUtils.INSTANCE.backupDotCProjectFile(project, (IProgressMonitor)monitor);
                project.close((IProgressMonitor)monitor);
                BufferedReader reader = null;
                BufferedWriter writer = null;
                ArrayList<String> lines = new ArrayList<String>();
                try {
                    try {
                        reader = new BufferedReader(new FileReader(path));
                        String line = null;
                        while ((line = reader.readLine()) != null) {
                            if (line.contains(ScannerConfigNature.NATURE_ID) || line.contains(ManagedCProjectNature.MNG_NATURE_ID) || line.contains("org.eclipse.cdt.core.ccnature") || line.contains("org.eclipse.cdt.core.cnature")) continue;
                            lines.add(line);
                        }
                        DVTUtilsCommon.INSTANCE.closeClosable((Closeable)reader);
                        writer = new BufferedWriter(new FileWriter(path));
                        for (String l : lines) {
                            writer.write(l);
                        }
                        DVTUtilsCommon.INSTANCE.closeClosable((Closeable)writer);
                    }
                    catch (IOException iOException) {
                        DVTUtilsCommon.INSTANCE.closeClosable(reader);
                        DVTUtilsCommon.INSTANCE.closeClosable(writer);
                        break block14;
                    }
                }
                catch (Throwable throwable) {
                    DVTUtilsCommon.INSTANCE.closeClosable(reader);
                    DVTUtilsCommon.INSTANCE.closeClosable(writer);
                    throw throwable;
                }
                DVTUtilsCommon.INSTANCE.closeClosable((Closeable)reader);
                DVTUtilsCommon.INSTANCE.closeClosable((Closeable)writer);
            }
            project.open(128, (IProgressMonitor)monitor);
        }
        catch (CoreException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }
}

