/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.cdt.ui.actions;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.index.IIndex;
import org.eclipse.cdt.core.index.IIndexBinding;
import org.eclipse.cdt.core.index.IIndexName;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.internal.ui.search.CSearchMessages;
import org.eclipse.cdt.internal.ui.search.CSearchQuery;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import ro.amiq.dvt.cdt.ui.actions.Location;
import ro.amiq.dvt.startup.core.DVTLogger;

public class CSearchBindingQuery
extends CSearchQuery {
    private final Set<Location> filteredLocations;
    private final String functionName;
    private IIndexBinding[] bindings;

    public CSearchBindingQuery(ICProject cproject, String functionName, IIndexBinding[] bindings) {
        super(new ICElement[]{cproject}, 4);
        this.functionName = functionName;
        this.bindings = bindings;
        this.filteredLocations = new HashSet<Location>();
    }

    public IStatus runWithIndex(IIndex index, IProgressMonitor monitor) throws OperationCanceledException {
        this.filteredLocations.clear();
        try {
            Object[] objectArray = new Object[3];
            objectArray[0] = index;
            objectArray[1] = this.bindings;
            if (this.invokeCreateMatches(new Class[]{IIndex.class, IBinding[].class, IASTNode.class}, objectArray) || this.invokeCreateMatches(new Class[]{IIndex.class, IBinding[].class}, new Object[]{index, this.bindings})) {
                return Status.OK_STATUS;
            }
            throw new CoreException((IStatus)new Status(4, "ro.amiq.dvt.cdt", "Incompatible CDT Plugin!"));
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            if (e instanceof CoreException) {
                return ((CoreException)((Object)e)).getStatus();
            }
            return new Status(4, "ro.amiq.dvt.cdt", "Incompatible CDT Plugin!", (Throwable)e);
        }
    }

    private boolean invokeCreateMatches(Class<?>[] argTypes, Object[] args) {
        try {
            Method method = CSearchQuery.class.getDeclaredMethod("createMatches", argTypes);
            method.invoke((Object)this, args);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return false;
        }
        catch (IllegalAccessException illegalAccessException) {
            return false;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return false;
        }
        catch (InvocationTargetException invocationTargetException) {
            return false;
        }
        return true;
    }

    protected boolean filterName(IIndexName name) {
        Location location = Location.create(name);
        if (location == null) {
            return false;
        }
        return !this.filteredLocations.add(location);
    }

    public String getResultLabel(int matchCount) {
        return this.getResultLabel(this.functionName, CSearchMessages.ProjectScope, matchCount);
    }
}

