/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.cdt.ui.actions;

import java.util.regex.PatternSyntaxException;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.dom.ILinkage;
import org.eclipse.cdt.core.dom.IName;
import org.eclipse.cdt.core.dom.IPDOMNode;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassType;
import org.eclipse.cdt.core.index.IIndex;
import org.eclipse.cdt.core.index.IIndexBinding;
import org.eclipse.cdt.core.index.IIndexName;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.internal.core.model.ext.ICElementHandle;
import org.eclipse.cdt.internal.ui.indexview.IndexLabelProvider;
import org.eclipse.cdt.internal.ui.typehierarchy.TypeHierarchyUI;
import org.eclipse.cdt.internal.ui.viewsupport.IndexUI;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.NewSearchUI;
import org.eclipse.ui.IWorkbenchWindow;
import ro.amiq.dvt.cdt.model.reflection.views.RfTreeElementWrapper;
import ro.amiq.dvt.cdt.ui.actions.CSearchBindingQuery;
import ro.amiq.dvt.cdt.utils.CDTUtils;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.startup.core.DVTUiUtils;
import ro.amiq.dvt.ui.actions.AMenuCommandDelegate;
import ro.amiq.dvt.ui.views.DVTTreeElementWrapper;
import ro.amiq.dvt.ui.views.IDVTElementWrapper;
import ro.amiq.dvt.ui.views.lazy.views.macros.CDTMacroWrapper;
import ro.amiq.dvt.utils.Utils;

public class MenuCommandDelegate
extends AMenuCommandDelegate {
    public boolean canHandle(IDVTElementWrapper wrapper) {
        return wrapper instanceof RfTreeElementWrapper || wrapper instanceof DVTTreeElementWrapper && wrapper.getRfElement() instanceof CDTMacroWrapper;
    }

    private RfTreeElementWrapper resolveWrapper(IDVTElementWrapper wrapper) {
        if (!(wrapper instanceof RfTreeElementWrapper)) {
            return null;
        }
        if (wrapper.getProject() == null) {
            return null;
        }
        return (RfTreeElementWrapper)wrapper;
    }

    public boolean canShowUsages(IDVTElementWrapper wrapper) {
        RfTreeElementWrapper rfWrapper = this.resolveWrapper(wrapper);
        if (rfWrapper == null) {
            return false;
        }
        if (!(rfWrapper.getRfElement() instanceof IPDOMNode)) {
            return false;
        }
        IPDOMNode ipdomNode = (IPDOMNode)rfWrapper.getRfElement();
        return !(ipdomNode instanceof ILinkage);
    }

    public boolean showUsages(IDVTElementWrapper wrapper) {
        RfTreeElementWrapper rfWrapper = this.resolveWrapper(wrapper);
        if (rfWrapper == null) {
            return false;
        }
        if (!(rfWrapper.getRfElement() instanceof IPDOMNode)) {
            return false;
        }
        IPDOMNode ipdomNode = (IPDOMNode)rfWrapper.getRfElement();
        IProject iProject = rfWrapper.getProject();
        if (iProject == null) {
            return false;
        }
        ICProject cProject = CoreModel.getDefault().getCModel().getCProject(iProject.getName());
        if (cProject == null) {
            return false;
        }
        IIndex index = null;
        try {
            index = CCorePlugin.getIndexManager().getIndex(cProject);
            IIndexBinding enclosing = index.findBinding((IName)CDTUtils.indexNameFromPDOMNode(ipdomNode));
            if (enclosing == null) {
                return false;
            }
            try {
                index.acquireReadLock();
                CSearchBindingQuery searchQuery = new CSearchBindingQuery(cProject, IndexLabelProvider.getText((IPDOMNode)ipdomNode), new IIndexBinding[]{enclosing});
                NewSearchUI.activateSearchResultView();
                NewSearchUI.runQueryInBackground((ISearchQuery)searchQuery);
            }
            catch (PatternSyntaxException e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
            }
            catch (CoreException e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
            }
            catch (InterruptedException e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
            }
        }
        finally {
            if (index != null) {
                index.releaseReadLock();
            }
        }
        return true;
    }

    public boolean canCopyInView(IDVTElementWrapper wrapper) {
        return this.resolveWrapper(wrapper) != null || wrapper instanceof DVTTreeElementWrapper && wrapper.getRfElement() instanceof CDTMacroWrapper;
    }

    public boolean copyInView(IDVTElementWrapper wrapper, String partID) {
        if (wrapper instanceof RfTreeElementWrapper) {
            RfTreeElementWrapper rfWrapper = this.resolveWrapper(wrapper);
            Utils.copyToClipboard((String)(rfWrapper == null ? "" : rfWrapper.toString()), (int)3);
        } else if (wrapper instanceof DVTTreeElementWrapper) {
            String macroText = "";
            if (wrapper.getRfElement() instanceof CDTMacroWrapper) {
                macroText = CDTUtils.getMacroWrapperString(wrapper.getRfElement());
            }
            Utils.copyToClipboard((String)macroText, (int)3);
        }
        return true;
    }

    public boolean canShowTypeHierarchy(IDVTElementWrapper wrapper) {
        RfTreeElementWrapper rfWrapper = this.resolveWrapper(wrapper);
        if (rfWrapper == null) {
            return false;
        }
        if (!(rfWrapper.getRfElement() instanceof IPDOMNode)) {
            return false;
        }
        IPDOMNode ipdomNode = (IPDOMNode)rfWrapper.getRfElement();
        if (!(ipdomNode instanceof ICPPClassType)) {
            return false;
        }
        return ((ICPPClassType)ipdomNode).getKey() == 3;
    }

    public boolean showTypeHierarchy(IDVTElementWrapper wrapper) {
        ICElementHandle icElement;
        block13: {
            IIndex index;
            ICProject cProject;
            RfTreeElementWrapper rfWrapper;
            block12: {
                block11: {
                    IProject iProject;
                    block10: {
                        block9: {
                            block8: {
                                try {
                                    rfWrapper = this.resolveWrapper(wrapper);
                                    if (rfWrapper != null) break block8;
                                    return false;
                                }
                                catch (CoreException e) {
                                    DVTLogger.INSTANCE.logError((Throwable)e);
                                    return false;
                                }
                            }
                            if (rfWrapper.getRfElement() instanceof IPDOMNode) break block9;
                            return false;
                        }
                        iProject = rfWrapper.getProject();
                        if (iProject != null) break block10;
                        return false;
                    }
                    cProject = CoreModel.getDefault().getCModel().getCProject(iProject.getName());
                    if (cProject != null) break block11;
                    return false;
                }
                index = CCorePlugin.getIndexManager().getIndex(cProject);
                if (index != null) break block12;
                return false;
            }
            IPDOMNode ipdomNode = (IPDOMNode)rfWrapper.getRfElement();
            icElement = IndexUI.getCElementForName((ICProject)cProject, (IIndex)index, (IIndexName)CDTUtils.indexNameFromPDOMNode(ipdomNode));
            if (icElement != null) break block13;
            return false;
        }
        TypeHierarchyUI.open((ICElement)icElement, (IWorkbenchWindow)DVTUiUtils.getActiveWorkbenchWindow());
        return true;
    }

    public boolean showDiagram(IDVTElementWrapper wrapper, String partID) {
        return false;
    }

    public boolean showLayers(IDVTElementWrapper wrapper) {
        return false;
    }

    public boolean showDesignHierarchy(IDVTElementWrapper wrapper, String partID) {
        return false;
    }

    public boolean showVerificationHierarchy(IDVTElementWrapper wrapper) {
        return false;
    }

    public boolean showUVMSequenceTree(IDVTElementWrapper wrapper) {
        return false;
    }

    public boolean showConstraints(IDVTElementWrapper wrapper) {
        return false;
    }

    public boolean showEmitters(IDVTElementWrapper wrapper) {
        return false;
    }

    public boolean showCallHierarchy(IDVTElementWrapper wrapper) {
        return false;
    }

    public boolean canShowImports(IDVTElementWrapper wrapper) {
        return false;
    }

    public boolean showImports(IDVTElementWrapper wrapper) {
        return false;
    }

    public boolean canShowPDDefinition(IDVTElementWrapper wrapper) {
        return false;
    }

    public boolean showPDDefinition(IDVTElementWrapper wrapper) {
        return false;
    }

    public boolean canShowComponentDiagram(IDVTElementWrapper wrapper) {
        return false;
    }

    public boolean canShowUsages(IRfNamedElement namedElement) {
        return false;
    }

    public boolean canShowLayers(IRfNamedElement namedElement) {
        return false;
    }

    public boolean canShowDesignHierarchy(IRfNamedElement namedElement) {
        return false;
    }

    public boolean canShowVerificationHierarchy(IRfNamedElement namedElement) {
        return false;
    }

    public boolean canShowHierarchy(IRfNamedElement namedElement) {
        return false;
    }

    public boolean canShowDiagram(IDVTElementWrapper wrapper) {
        return false;
    }

    public boolean canCopyInView(IRfNamedElement namedElement) {
        return false;
    }

    public boolean canShowUVMSequenceTree(IRfNamedElement namedElement) {
        return false;
    }

    public boolean canShowConstraints(IRfNamedElement namedElement, boolean onlyRand) {
        return false;
    }

    public boolean canShowCallHierarchy(IRfNamedElement namedElement) {
        return false;
    }

    public boolean showSNDiagram(IDVTElementWrapper wrapper) {
        return false;
    }

    public boolean showInstances(IDVTElementWrapper wrapper) {
        return false;
    }

    public boolean showInstancesInDH(IDVTElementWrapper wrapper) {
        return false;
    }

    public boolean showAllInstancesInDH(IDVTElementWrapper wrapper) {
        return this.showInstancesInDH(wrapper);
    }

    public boolean canShowSNDiagram(IDVTElementWrapper wrapper) {
        return false;
    }

    public boolean showConnectionsDiagram(IDVTElementWrapper wrapper) {
        return false;
    }

    public boolean canShowConnectionsDiagram(IRfNamedElement namedElement) {
        return false;
    }

    public boolean showReadersUsages(IDVTElementWrapper wrapper) {
        return false;
    }

    public boolean showWritersUsages(IDVTElementWrapper wrapper) {
        return false;
    }

    public boolean showConnectedTLMPorts(IDVTElementWrapper wrapper) {
        return false;
    }

    public boolean canShowConnectedTLMPorts(IRfNamedElement namedElement) {
        return false;
    }

    public boolean showScenarioDiagram(IDVTElementWrapper wrapper, String partID) {
        return false;
    }

    public boolean canShowScenarioDiagram(IDVTElementWrapper wrapper) {
        return false;
    }

    public boolean showActivityDiagram(IDVTElementWrapper wrapper, String partID) {
        return false;
    }

    public boolean canShowActivityDiagram(IDVTElementWrapper wrapper) {
        return false;
    }

    public boolean canShowWaveViewerFieldActions(IDVTElementWrapper wrapper) {
        return false;
    }

    public boolean addToWaveViewer(IDVTElementWrapper wrapper) {
        return false;
    }

    public boolean addWithDriversToWaveViewer(IDVTElementWrapper wrapper) {
        return false;
    }

    public boolean addWithLoadsToWaveViewer(IDVTElementWrapper wrapper) {
        return false;
    }

    public boolean canShowWaveViewerInstanceActions(IDVTElementWrapper wrapper) {
        return false;
    }

    public boolean addInstancePortsToWaveViewer(IDVTElementWrapper wrapper) {
        return false;
    }

    public boolean addAllInstanceSignalsToWaveViewer(IDVTElementWrapper wrapper) {
        return false;
    }
}

