/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.cdt.ui.guifilters;

import java.util.List;
import org.eclipse.cdt.core.dom.ILinkage;
import org.eclipse.cdt.core.dom.IPDOMNode;
import org.eclipse.cdt.core.dom.ast.ICompositeType;
import org.eclipse.cdt.core.dom.ast.ITypedef;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPNamespace;
import org.eclipse.cdt.core.parser.IMacro;
import org.eclipse.core.resources.IProject;
import ro.amiq.dvt.ui.guifilters.DVTGUIFilterMatcher;
import ro.amiq.dvt.ui.guifilters.ElementType;
import ro.amiq.dvt.ui.guifilters.GUIFilter;
import ro.amiq.dvt.ui.guifilters.ViewSet;

public class CDTGUIFilterMatcher
extends DVTGUIFilterMatcher {
    public CDTGUIFilterMatcher(IPDOMNode element, String parserPath, List<GUIFilter> filters, String name, ViewSet.ViewName viewName, IProject project) {
        this.fViewName = viewName;
        this.fParserPath = parserPath;
        this.fProject = project;
        this.fFilters = filters;
        this.fTextProvider = () -> name;
        this.fTypeProvider = () -> this.isFiltered(element);
    }

    public ElementType isFiltered(IPDOMNode el) {
        if (el instanceof ICPPClassType) {
            switch (((ICPPClassType)el).getKey()) {
                case 3: {
                    return new ElementType(ElementType.ElementTypeName.CLASS, ElementType.ElementTypeLanguage.CPP);
                }
                case 1: {
                    return new ElementType(ElementType.ElementTypeName.STRUCT, ElementType.ElementTypeLanguage.CPP);
                }
                case 2: {
                    return new ElementType(ElementType.ElementTypeName.UNION, ElementType.ElementTypeLanguage.CPP);
                }
            }
        }
        if (el instanceof ICompositeType) {
            switch (((ICompositeType)el).getKey()) {
                case 3: {
                    return new ElementType(ElementType.ElementTypeName.CLASS, ElementType.ElementTypeLanguage.CPP);
                }
                case 1: {
                    return new ElementType(ElementType.ElementTypeName.STRUCT, ElementType.ElementTypeLanguage.CPP);
                }
                case 2: {
                    return new ElementType(ElementType.ElementTypeName.UNION, ElementType.ElementTypeLanguage.CPP);
                }
            }
        } else {
            if (el instanceof ICPPNamespace) {
                return new ElementType(ElementType.ElementTypeName.NAMESPACE, ElementType.ElementTypeLanguage.CPP);
            }
            if (el instanceof ILinkage) {
                return new ElementType(ElementType.ElementTypeName.LINKAGE, ElementType.ElementTypeLanguage.CPP);
            }
            if (el instanceof ITypedef) {
                return new ElementType(ElementType.ElementTypeName.TYPEDEF, ElementType.ElementTypeLanguage.CPP);
            }
            if (el instanceof IMacro) {
                return new ElementType(ElementType.ElementTypeName.MACRO, ElementType.ElementTypeLanguage.CPP);
            }
        }
        return null;
    }

    public static DVTGUIFilterMatcher.GUIFilterResult filterElement(IPDOMNode element, String parserPath, List<GUIFilter> filters, String name, ViewSet.ViewName viewName, IProject project) {
        return new CDTGUIFilterMatcher(element, parserPath, filters, name, viewName, project).matches();
    }
}

