/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.cdt.utils;

import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.browser.IndexTypeInfo;
import org.eclipse.cdt.core.dom.IPDOMNode;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.index.IIndexName;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.IMacro;
import org.eclipse.cdt.internal.core.index.IIndexFragmentName;
import org.eclipse.cdt.internal.core.pdom.PDOM;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMBinding;
import org.eclipse.cdt.internal.ui.indexview.IndexLabelProvider;
import org.eclipse.cdt.ui.browser.typeinfo.TypeInfoLabelProvider;
import org.eclipse.core.runtime.CoreException;
import ro.amiq.dvt.cdt.model.reflection.views.CDTLanguageElement;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.views.lazy.views.macros.CDTMacroWrapper;

public class CDTUtils {
    private static final int INDEXER_TIMEOUT = 300000;

    public static void waitForCDTIndexerIdle() {
        long timeout = System.currentTimeMillis() + 300000L;
        while (!CCorePlugin.getIndexManager().isIndexerIdle()) {
            try {
                Thread.sleep(50L);
                if (System.currentTimeMillis() <= timeout) continue;
                DVTLogger.INSTANCE.logError("Timed out while waiting for CDT indexer to be done");
                break;
            }
            catch (InterruptedException e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
            }
        }
    }

    public static IIndexName indexNameFromPDOMNode(IPDOMNode element) {
        if (!(element instanceof PDOMBinding)) {
            return null;
        }
        try {
            IIndexFragmentName[] names;
            PDOMBinding binding = (PDOMBinding)element;
            PDOM pdom = binding.getPDOM();
            IIndexFragmentName[] iIndexFragmentNameArray = names = pdom.findNames((IBinding)binding, 3);
            int n = names.length;
            int n2 = 0;
            while (n2 < n) {
                IIndexFragmentName name = iIndexFragmentNameArray[n2];
                if (name.getFile().getLocation().getFullPath() != null) {
                    return name;
                }
                ++n2;
            }
        }
        catch (CoreException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        return null;
    }

    public static ICElement getMacroFromCElements(ICElement[] cElements) {
        if (cElements == null || cElements.length == 0) {
            return null;
        }
        ICElement[] iCElementArray = cElements;
        int n = cElements.length;
        int n2 = 0;
        while (n2 < n) {
            ICElement cElem = iCElementArray[n2];
            if (cElem instanceof IMacro) {
                return cElem;
            }
            ++n2;
        }
        return null;
    }

    public static String getMacroWrapperString(Object element) {
        Object rfElement = element;
        if (element instanceof CDTMacroWrapper) {
            rfElement = ((CDTMacroWrapper)element).getRfElement();
        }
        if (rfElement instanceof CDTLanguageElement) {
            return (String)((CDTLanguageElement)((Object)rfElement)).getInfo();
        }
        if (rfElement instanceof IPDOMNode) {
            return IndexLabelProvider.getText((IPDOMNode)((IPDOMNode)rfElement));
        }
        if (rfElement instanceof IndexTypeInfo) {
            return new TypeInfoLabelProvider(17).getText(rfElement);
        }
        if (rfElement != null) {
            return rfElement.toString();
        }
        return "null";
    }
}

