/*
 * Decompiled with CFR 0.152.
 */
package com.swtxml.definition.impl;

import com.swtxml.definition.DefinitionException;
import com.swtxml.definition.IAttributeDefinition;
import com.swtxml.definition.INamespaceDefinition;
import com.swtxml.definition.ITagDefinition;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class NamespaceDefinition
implements INamespaceDefinition {
    private Map<String, ITagDefinition> tagsByName = new HashMap<String, ITagDefinition>();
    private Map<String, IAttributeDefinition> foreignAttributes = new HashMap<String, IAttributeDefinition>();

    @Override
    public ITagDefinition getTag(String name) {
        return this.tagsByName.get(name);
    }

    @Override
    public Set<String> getTagNames() {
        return Collections.unmodifiableSet(this.tagsByName.keySet());
    }

    public void defineTag(ITagDefinition tag) {
        ITagDefinition existingTag = this.tagsByName.get(tag.getName());
        if (existingTag != null) {
            throw new DefinitionException("Tag naming conflict between " + tag + " and " + existingTag + "!");
        }
        this.tagsByName.put(tag.getName(), tag);
    }

    public void defineForeignAttribute(IAttributeDefinition attr) {
        this.foreignAttributes.put(attr.getName(), attr);
    }

    @Override
    public Set<String> getForeignAttributeNames() {
        return Collections.unmodifiableSet(this.foreignAttributes.keySet());
    }

    @Override
    public IAttributeDefinition getForeignAttribute(String name) {
        return this.foreignAttributes.get(name);
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + "[" + this.tagsByName + ", " + this.foreignAttributes + "]";
    }
}

