/*
 * Decompiled with CFR 0.152.
 */
package com.swtxml.definition.impl;

import com.swtxml.definition.IAttributeDefinition;
import com.swtxml.definition.ITagDefinition;
import com.swtxml.definition.ITagScope;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class TagDefinition
implements ITagDefinition,
ITagScope {
    private final String name;
    private final Map<String, IAttributeDefinition> attributes = new HashMap<String, IAttributeDefinition>();
    private Set<ITagDefinition> allowedParentTags;

    public TagDefinition(String name, ITagDefinition ... allowedParentTags) {
        this.name = name;
        this.allowedParentTags = new HashSet<ITagDefinition>(Arrays.asList(allowedParentTags));
    }

    @Override
    public IAttributeDefinition getAttribute(String name) {
        return this.attributes.get(name);
    }

    @Override
    public Set<String> getAttributeNames() {
        return Collections.unmodifiableSet(this.attributes.keySet());
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void defineAttribute(IAttributeDefinition attributeDefinition) {
        this.attributes.put(attributeDefinition.getName(), attributeDefinition);
    }

    @Override
    public boolean isAllowedIn(ITagDefinition parentTagDefinition) {
        return this.allowedParentTags.contains(parentTagDefinition);
    }

    public TagDefinition allowNested() {
        this.allowedParentTags.add(this);
        return this;
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + "[" + this.name + "]";
    }
}

