/*
 * Decompiled with CFR 0.152.
 */
package com.swtxml.events.registry;

import com.swtxml.events.registry.WidgetEvent;
import com.swtxml.events.registry.WidgetEvents;
import com.swtxml.swt.SwtInfo;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.swt.widgets.Widget;

public class EventsRegistry {
    private final Set<String> allEventNames;
    private final Map<Class<?>, WidgetEvents> widgetClasses;

    public EventsRegistry() {
        HashSet<String> bAllEventNames = new HashSet<String>();
        HashMap<Class<? extends Widget>, WidgetEvents> bWidgetClasses = new HashMap<Class<? extends Widget>, WidgetEvents>();
        for (String widgetClassName : SwtInfo.WIDGETS.getWidgetClassNames()) {
            Class<? extends Widget> widgetClass = SwtInfo.WIDGETS.getWidgetClass(widgetClassName);
            WidgetEvents events = new WidgetEvents(widgetClass);
            bWidgetClasses.put(widgetClass, events);
            bAllEventNames.addAll(events.getEventNames());
        }
        this.widgetClasses = Collections.unmodifiableMap(bWidgetClasses);
        this.allEventNames = Collections.unmodifiableSet(bAllEventNames);
    }

    public Collection<String> getAllEventNames() {
        return this.allEventNames;
    }

    public WidgetEvent getWidgetEvent(Class<?> widgetClass, String eventName) {
        WidgetEvents widgetEvents = this.widgetClasses.get(widgetClass);
        return widgetEvents != null ? widgetEvents.getEvent(eventName) : null;
    }
}

