/*
 * Decompiled with CFR 0.152.
 */
package com.swtxml.events.registry;

import com.swtxml.events.registry.WidgetEvent;
import com.swtxml.util.lang.ContractProof;
import com.swtxml.util.reflector.Reflector;
import com.swtxml.util.reflector.Subclasses;
import com.swtxml.util.reflector.Visibility;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.EventListener;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.custom.ExtendedModifyListener;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.widgets.Widget;

class WidgetEvents {
    private Map<String, WidgetEvent> events = new HashMap<String, WidgetEvent>();

    public WidgetEvents(Class<? extends Widget> widgetClass) {
        Collection<Method> listenerMethods = Reflector.findMethods(Visibility.PUBLIC, Subclasses.INCLUDE).parameters(EventListener.class).nameMatches("add.+Listener").all(widgetClass);
        for (Method listenerMethod : listenerMethods) {
            Class<?> listenerType = listenerMethod.getParameterTypes()[0];
            Method[] methodArray = listenerType.getMethods();
            int n = methodArray.length;
            int n2 = 0;
            while (n2 < n) {
                Method eventMethod = methodArray[n2];
                String eventName = this.getEventName(listenerMethod, eventMethod, listenerType);
                Class<?> eventParamType = eventMethod.getParameterTypes()[0];
                ContractProof.safePut(this.events, eventName, new WidgetEvent(listenerType, eventParamType));
                ++n2;
            }
        }
    }

    private String getEventName(Method listenerMethod, Method eventMethod, Class<?> listenerType) {
        if (StyledText.class == listenerMethod.getDeclaringClass() && ExtendedModifyListener.class == listenerType) {
            return "extendedModifyText";
        }
        if (Browser.class == listenerMethod.getDeclaringClass()) {
            return String.valueOf(StringUtils.uncapitalize((String)StringUtils.replace((String)listenerType.getSimpleName(), (String)"Listener", (String)""))) + StringUtils.capitalize((String)eventMethod.getName());
        }
        return eventMethod.getName();
    }

    public Collection<String> getEventNames() {
        return this.events.keySet();
    }

    public WidgetEvent getEvent(String eventName) {
        return this.events.get(eventName);
    }
}

