/*
 * Decompiled with CFR 0.152.
 */
package com.swtxml.events.visitor;

import com.swtxml.definition.IAttributeDefinition;
import com.swtxml.events.EventListenerException;
import com.swtxml.events.impl.Events;
import com.swtxml.events.registry.WidgetEvent;
import com.swtxml.swt.metadata.WidgetTag;
import com.swtxml.tinydom.ITagVisitor;
import com.swtxml.tinydom.Tag;
import com.swtxml.util.lang.ContractProof;
import com.swtxml.util.reflector.Reflector;
import com.swtxml.util.reflector.ReflectorException;
import com.swtxml.util.reflector.Subclasses;
import com.swtxml.util.reflector.Visibility;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import org.eclipse.swt.widgets.Widget;

public class CreateEventListeners
implements ITagVisitor {
    private Object viewObject;

    public CreateEventListeners(Object viewObject) {
        this.viewObject = viewObject;
    }

    @Override
    public void visit(Tag tag) {
        if (!(tag.getTagDefinition() instanceof WidgetTag)) {
            return;
        }
        Class<? extends Widget> widgetClass = ((WidgetTag)tag.getTagDefinition()).getWidgetClass();
        for (IAttributeDefinition event : tag.getAttributes(Events.NAMESPACE)) {
            this.wireViewMethodListener(tag.getAttribute(Events.NAMESPACE, event), tag.adaptTo(widgetClass), event.getName());
        }
    }

    public void wireViewMethodListener(String viewMethodName, Widget widget, final String eventName) {
        WidgetEvent event = Events.EVENTS.getWidgetEvent(widget.getClass(), eventName);
        ContractProof.notNull(event, "event");
        final Method viewMethod = Reflector.findMethods(Visibility.PRIVATE, Subclasses.INCLUDE).name(viewMethodName.trim()).optionalParameter(event.getEventParamType()).exactOne(this.viewObject.getClass());
        InvocationHandler handler = new InvocationHandler(){

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                if (!method.getName().equals(eventName)) {
                    return null;
                }
                viewMethod.setAccessible(true);
                Object[] parameters = args;
                if (viewMethod.getParameterTypes().length == 0) {
                    parameters = new Object[]{};
                }
                try {
                    return viewMethod.invoke(CreateEventListeners.this.viewObject, parameters);
                }
                catch (RuntimeException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new EventListenerException(e);
                }
            }
        };
        Class<?> listenerType = event.getListenerType();
        Object listenerProxy = Proxy.newProxyInstance(this.viewObject.getClass().getClassLoader(), new Class[]{listenerType}, handler);
        Method addMethod = Reflector.findMethods(Visibility.PUBLIC, Subclasses.INCLUDE).nameStartsWith("add").parameters(listenerType).exactOne(widget.getClass());
        try {
            addMethod.invoke((Object)widget, listenerProxy);
        }
        catch (Exception e) {
            new ReflectorException(e);
        }
    }
}

