/*
 * Decompiled with CFR 0.152.
 */
package com.swtxml.extensions;

import com.swtxml.definition.INamespaceDefinition;
import com.swtxml.definition.INamespaceResolver;
import com.swtxml.util.parser.ParseException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;

public class ExtensionsNamespaceResolver
implements INamespaceResolver {
    private static final String NAMESPACE_EXTENSION_POINT_ID = "com.swtxml.namespaces";

    @Override
    public INamespaceDefinition resolveNamespace(String uri) {
        IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint(NAMESPACE_EXTENSION_POINT_ID);
        IExtension[] iExtensionArray = extensionPoint.getExtensions();
        int n = iExtensionArray.length;
        int n2 = 0;
        while (n2 < n) {
            IExtension extension = iExtensionArray[n2];
            IConfigurationElement[] iConfigurationElementArray = extension.getConfigurationElements();
            int n3 = iConfigurationElementArray.length;
            int n4 = 0;
            while (n4 < n3) {
                IConfigurationElement configurationElement = iConfigurationElementArray[n4];
                if (!"namespaceResolver".equals(configurationElement.getName())) {
                    throw new ParseException("Invalid com.swtxml.namespaces element: " + configurationElement);
                }
                INamespaceResolver resolver = this.getNamespaceResolver(configurationElement);
                INamespaceDefinition namespace = resolver.resolveNamespace(uri);
                if (namespace != null) {
                    return namespace;
                }
                ++n4;
            }
            ++n2;
        }
        return null;
    }

    private INamespaceResolver getNamespaceResolver(IConfigurationElement configurationElement) {
        try {
            return (INamespaceResolver)configurationElement.createExecutableExtension("class");
        }
        catch (CoreException e) {
            throw new ParseException(e.getMessage(), e);
        }
    }
}

