/*
 * Decompiled with CFR 0.152.
 */
package com.swtxml.i18n;

import com.swtxml.i18n.ILabelTranslator;
import com.swtxml.resources.IDocumentResource;
import com.swtxml.util.lang.ContractProof;
import com.swtxml.util.lang.FilenameUtils;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import org.apache.commons.lang.StringUtils;

public class ResourceBundleLabelTranslator
implements ILabelTranslator {
    private final List<ResourceBundle> resourceBundles;

    public ResourceBundleLabelTranslator(IDocumentResource document, Locale locale) {
        ContractProof.notNull(document, "document");
        String documentName = FilenameUtils.getBaseName(document.getDocumentName());
        List<String> resourceBundleNames = this.getResourceBundleNames(documentName, locale);
        resourceBundleNames.addAll(this.getResourceBundleNames("messages", locale));
        resourceBundleNames.addAll(this.getResourceBundleNames("bundle:messages", locale));
        resourceBundleNames.addAll(this.getResourceBundleNames("bundle:plugin", locale));
        this.resourceBundles = new ArrayList<ResourceBundle>();
        for (String name : resourceBundleNames) {
            try {
                InputStream resource = document.resolve(String.valueOf(name) + ".properties");
                if (resource == null) continue;
                this.resourceBundles.add(new PropertyResourceBundle(resource));
            }
            catch (MissingResourceException missingResourceException) {
            }
            catch (IOException iOException) {}
        }
    }

    @Override
    public String translate(String key) {
        for (ResourceBundle resourceBundle : this.resourceBundles) {
            try {
                String value = resourceBundle.getString(key);
                if (value == null) continue;
                return value;
            }
            catch (MissingResourceException missingResourceException) {}
        }
        return "??? " + key + " ???";
    }

    private List<String> getResourceBundleNames(String baseName, Locale locale) {
        ArrayList<String> results = new ArrayList<String>(4);
        if (StringUtils.isNotEmpty((String)locale.getLanguage())) {
            if (StringUtils.isNotEmpty((String)locale.getCountry())) {
                if (StringUtils.isNotEmpty((String)locale.getVariant())) {
                    results.add(String.valueOf(baseName) + "_" + locale.getLanguage() + "_" + locale.getCountry() + "_" + locale.getVariant());
                }
                results.add(String.valueOf(baseName) + "_" + locale.getLanguage() + "_" + locale.getCountry());
            }
            results.add(String.valueOf(baseName) + "_" + locale.getLanguage());
        }
        results.add(baseName);
        return results;
    }
}

