/*
 * Decompiled with CFR 0.152.
 */
package com.swtxml.swt;

import com.swtxml.adapter.IAdaptable;
import com.swtxml.definition.INamespaceResolver;
import com.swtxml.events.visitor.CreateEventListeners;
import com.swtxml.extensions.DefaultNamespaceResolver;
import com.swtxml.extensions.ExtensionsNamespaceResolver;
import com.swtxml.i18n.ILabelTranslator;
import com.swtxml.i18n.ResourceBundleLabelTranslator;
import com.swtxml.resources.ClassResource;
import com.swtxml.resources.IDocumentResource;
import com.swtxml.swt.SwtResourceManager;
import com.swtxml.swt.byid.ByIdInjector;
import com.swtxml.swt.visitor.BuildWidgets;
import com.swtxml.swt.visitor.CollectIds;
import com.swtxml.swt.visitor.SetAttributes;
import com.swtxml.swt.visitor.TagContextVisitor;
import com.swtxml.tinydom.Tag;
import com.swtxml.tinydom.TinyDomParser;
import com.swtxml.util.context.Context;
import com.swtxml.util.eclipse.EclipseEnvironment;
import java.util.Locale;
import org.eclipse.swt.widgets.Composite;

public class SwtXmlParser
extends TinyDomParser
implements IAdaptable {
    private Composite rootComposite;
    private Object view;
    private SwtResourceManager resourceManager;
    private ResourceBundleLabelTranslator labelTranslator;

    public SwtXmlParser(Composite rootComposite, IDocumentResource resource, Object view) {
        super(SwtXmlParser.getSwtNamespaceResolver(), resource);
        this.rootComposite = rootComposite;
        this.view = view;
    }

    public SwtXmlParser(Composite rootComposite, Object view) {
        this(rootComposite, ClassResource.coLocated(view.getClass(), "swtxml"), view);
    }

    private static INamespaceResolver getSwtNamespaceResolver() {
        if (EclipseEnvironment.isAvailable()) {
            return new ExtensionsNamespaceResolver();
        }
        return new DefaultNamespaceResolver();
    }

    @Override
    public <A> A adaptTo(Class<A> adapterClass) {
        A result = super.adaptTo(adapterClass);
        if (result != null) {
            return result;
        }
        if (SwtResourceManager.class.isAssignableFrom(adapterClass)) {
            if (this.resourceManager == null) {
                this.resourceManager = new SwtResourceManager(this.rootComposite);
            }
            return (A)this.resourceManager;
        }
        if (ILabelTranslator.class.isAssignableFrom(adapterClass)) {
            if (this.labelTranslator == null) {
                this.labelTranslator = new ResourceBundleLabelTranslator(this.document, Locale.getDefault());
            }
            return (A)this.labelTranslator;
        }
        return null;
    }

    @Override
    protected void onParseCompleted(final Tag root) {
        final CollectIds ids = new CollectIds();
        final TagContextVisitor buildWidgets = new TagContextVisitor(new BuildWidgets(this.rootComposite));
        final TagContextVisitor setAttributes = new TagContextVisitor(new SetAttributes());
        root.visitDepthFirst(ids);
        Context.runWith(new Runnable(){

            @Override
            public void run() {
                Context.addAdapter(ids);
                Context.addAdapter(SwtXmlParser.this);
                root.visitDepthFirst(buildWidgets);
                root.visitDepthFirst(setAttributes);
            }
        });
        if (this.view != null) {
            root.visitDepthFirst(new CreateEventListeners(this.view));
            new ByIdInjector().inject(this.view, ids);
        }
    }
}

