/*
 * Decompiled with CFR 0.152.
 */
package com.swtxml.swt.metadata;

import com.swtxml.definition.DefinitionException;
import com.swtxml.util.lang.CollectionUtils;
import com.swtxml.util.lang.IFilter;
import com.swtxml.util.lang.ResourceUtils;
import com.swtxml.util.parser.ParseException;
import java.lang.reflect.Constructor;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.eclipse.swt.widgets.Widget;

public class WidgetRegistry {
    private Map<String, String[]> widgetStylesByClassName = new HashMap<String, String[]>();

    public WidgetRegistry() {
        String widgetClasses = ResourceUtils.toString(ResourceUtils.getClassResource(this.getClass(), "txt"));
        String[] stringArray = StringUtils.split((String)widgetClasses, (String)"\n");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            String[] parts = StringUtils.split((String)line, (char)'=');
            String className = parts[0].trim();
            String[] allowedStyles = parts.length > 1 ? StringUtils.split((String)parts[1].trim(), (String)", ") : new String[]{};
            this.widgetStylesByClassName.put(className, allowedStyles);
            ++n2;
        }
    }

    public Collection<String> getWidgetClassNames() {
        return this.widgetStylesByClassName.keySet();
    }

    public Collection<String> getAllowedStylesFor(Class<?> widgetClass) {
        HashSet<String> allowedStyles = new HashSet<String>();
        do {
            String[] styles;
            if ((styles = this.widgetStylesByClassName.get(widgetClass.getName())) == null) {
                throw new ParseException("Unknown widget super class: " + widgetClass);
            }
            allowedStyles.addAll(Arrays.asList(styles));
        } while ((widgetClass = widgetClass.getSuperclass()).getSuperclass() != null && !Object.class.equals(widgetClass));
        return allowedStyles;
    }

    public Class<? extends Widget> getWidgetClass(String className) {
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            throw new DefinitionException(e);
        }
    }

    public Constructor getWidgetConstructor(Class<? extends Widget> widgetClass) {
        return CollectionUtils.find(Arrays.asList(widgetClass.getConstructors()), new IFilter<Constructor>(){

            @Override
            public boolean match(Constructor constructor) {
                return constructor.getParameterTypes().length == 2 && constructor.getParameterTypes()[1] == Integer.TYPE;
            }
        });
    }

    public Class<?> getAllowedParentType(Class<? extends Widget> type) {
        Constructor constructor = this.getWidgetConstructor(type);
        return constructor.getParameterTypes()[0];
    }
}

