/*
 * Decompiled with CFR 0.152.
 */
package com.swtxml.swt.metadata;

import com.swtxml.definition.IAttributeDefinition;
import com.swtxml.definition.ITagDefinition;
import com.swtxml.definition.ITagScope;
import com.swtxml.definition.impl.AttributeDefinition;
import com.swtxml.swt.SwtInfo;
import com.swtxml.swt.metadata.PropertyAttribute;
import com.swtxml.swt.types.StyleType;
import com.swtxml.util.parser.ConstantParser;
import com.swtxml.util.properties.ClassProperties;
import com.swtxml.util.properties.Property;
import com.swtxml.util.types.SimpleTypes;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Widget;

public class WidgetTag
implements ITagDefinition,
ITagScope {
    private Class<? extends Widget> widgetClass;
    private Map<String, IAttributeDefinition> attributes;

    public WidgetTag(Class<? extends Widget> widgetClass) {
        this.setWidgetClass(widgetClass);
        this.addStyles(widgetClass);
    }

    public WidgetTag(Class<? extends Widget> widgetClass, String allowedStyles) {
        this.setWidgetClass(widgetClass);
        this.addStyles(SwtInfo.SWT.filter(allowedStyles));
    }

    private void setWidgetClass(Class<? extends Widget> widgetClass) {
        this.widgetClass = widgetClass;
        ClassProperties<? extends Widget> properties = SwtInfo.WIDGET_PROPERTIES.getProperties(widgetClass);
        this.attributes = new HashMap<String, IAttributeDefinition>();
        for (Property property : properties.getProperties().values()) {
            PropertyAttribute attribute = new PropertyAttribute(property);
            this.attributes.put(attribute.getName(), attribute);
        }
        this.attributes.put("id", new AttributeDefinition("id", SimpleTypes.STRING));
    }

    private void addStyles(Class<? extends Widget> widgetClass) {
        Collection<String> allowedWidgetStyles = SwtInfo.WIDGETS.getAllowedStylesFor(widgetClass);
        this.addStyles(SwtInfo.SWT.filter(allowedWidgetStyles));
    }

    private void addStyles(ConstantParser styles) {
        if (!styles.getConstants().isEmpty()) {
            this.attributes.put("style", new AttributeDefinition("style", new StyleType(styles)));
        }
    }

    public Class<? extends Widget> getWidgetClass() {
        return this.widgetClass;
    }

    @Override
    public String getName() {
        return this.widgetClass.getSimpleName();
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + "[" + this.widgetClass + "]";
    }

    @Override
    public IAttributeDefinition getAttribute(String name) {
        return this.attributes.get(name);
    }

    @Override
    public Set<String> getAttributeNames() {
        return Collections.unmodifiableSet(this.attributes.keySet());
    }

    @Override
    public boolean isAllowedIn(ITagDefinition parentTagDefinition) {
        if (parentTagDefinition == ITagDefinition.ROOT) {
            return Composite.class.isAssignableFrom(this.getWidgetClass());
        }
        if (parentTagDefinition instanceof WidgetTag) {
            Class<? extends Widget> actualParentClass = ((WidgetTag)parentTagDefinition).getWidgetClass();
            Class<? extends Widget> allowedParentClass = SwtInfo.WIDGETS.getAllowedParentType(this.getWidgetClass());
            if (TabItem.class.equals(actualParentClass)) {
                return Control.class.isAssignableFrom(this.getWidgetClass());
            }
            if (TabFolder.class.equals(actualParentClass)) {
                return TabItem.class.isAssignableFrom(this.getWidgetClass());
            }
            return allowedParentClass.isAssignableFrom(actualParentClass);
        }
        return false;
    }
}

