/*
 * Decompiled with CFR 0.152.
 */
package com.swtxml.swt.types;

import com.swtxml.adapter.IIdResolver;
import com.swtxml.swt.SwtInfo;
import com.swtxml.util.context.Context;
import com.swtxml.util.parser.ConstantParser;
import com.swtxml.util.parser.ParseException;
import com.swtxml.util.types.IType;
import java.util.ArrayList;
import org.apache.commons.lang.StringUtils;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.widgets.Control;

public class FormAttachmentType
implements IType<FormAttachment> {
    private static final ConstantParser CONSTANTS_ALIGN = SwtInfo.SWT.filter("TOP|BOTTOM|LEFT|RIGHT|CENTER|DEFAULT");

    @Override
    public FormAttachment convert(String value) {
        FormAttachment attachment = new FormAttachment();
        ArrayList<String> parts = new ArrayList<String>();
        int start = 0;
        int i = 0;
        while (i < value.length()) {
            char charAt = value.charAt(i);
            if (charAt == '-' || charAt == '+') {
                parts.add(value.substring(start, i).trim());
                start = i;
            }
            ++i;
        }
        parts.add(value.substring(start, value.length()).trim());
        for (String part : parts) {
            if (part.endsWith("%")) {
                if (part.startsWith("+")) {
                    part = part.substring(1);
                }
                attachment.numerator = Integer.parseInt(part.substring(0, part.length() - 1));
                continue;
            }
            try {
                if (part.startsWith("+")) {
                    part = part.substring(1);
                }
                attachment.offset = Integer.parseInt(part);
            }
            catch (NumberFormatException numberFormatException) {
                String[] controlString = StringUtils.split((String)part, (String)".");
                if (controlString.length >= 1) {
                    String id = controlString[0].trim();
                    IIdResolver idResolver = Context.adaptTo(IIdResolver.class);
                    if (idResolver == null) {
                        throw new ParseException("No IDs available in current context");
                    }
                    Control control = idResolver.getById(id, Control.class);
                    if (control == null) {
                        throw new ParseException("Control with id \"" + id + "\" not found");
                    }
                    attachment.control = control;
                }
                if (controlString.length < 2) continue;
                String align = controlString[1].trim();
                attachment.alignment = CONSTANTS_ALIGN.getIntValue(align);
            }
        }
        return attachment;
    }
}

