/*
 * Decompiled with CFR 0.152.
 */
package com.swtxml.swt.types;

import com.swtxml.swt.SwtInfo;
import com.swtxml.util.parser.KeyValueParser;
import com.swtxml.util.parser.ParseException;
import com.swtxml.util.parser.Strictness;
import com.swtxml.util.properties.ClassProperties;
import com.swtxml.util.properties.IInjector;
import com.swtxml.util.properties.PropertiesContentAssist;
import com.swtxml.util.proposals.Match;
import com.swtxml.util.reflector.ReflectorException;
import com.swtxml.util.types.IContentAssistable;
import com.swtxml.util.types.IType;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Layout;

public class LayoutType
implements IType<Layout>,
IContentAssistable {
    private static final String LAYOUT_KEY = "layout";
    private final String[] LAYOUTS = new String[]{"fill", "row", "grid", "form"};
    private static final String SWT_LAYOUT_PACKAGE = RowLayout.class.getPackage().getName();

    @Override
    public Layout convert(String value) {
        return this.convert(value, Strictness.STRICT);
    }

    public Layout convert(String value, Strictness strictness) {
        Map<String, String> layoutConstraints = KeyValueParser.parse(value, strictness);
        String layoutName = layoutConstraints.remove(LAYOUT_KEY);
        if (layoutName == null) {
            if (strictness == Strictness.STRICT) {
                throw new ParseException("no layout specified");
            }
            return null;
        }
        Layout layout = this.createLayout(layoutName, Strictness.STRICT);
        IInjector injector = SwtInfo.LAYOUT_PROPERTIES.getProperties(layout.getClass()).getInjector(layout);
        injector.setPropertyValues(layoutConstraints);
        return layout;
    }

    private Layout createLayout(String layoutName, Strictness strictness) {
        try {
            return this.getLayoutClass(layoutName, strictness).newInstance();
        }
        catch (Exception e) {
            if (strictness == Strictness.STRICT) {
                throw new ReflectorException(e);
            }
            return null;
        }
    }

    private Class<? extends Layout> getLayoutClass(String layoutName, Strictness strictness) {
        String className = String.valueOf(SWT_LAYOUT_PACKAGE) + "." + StringUtils.capitalize((String)layoutName) + "Layout";
        try {
            return Class.forName(className);
        }
        catch (Exception e) {
            if (strictness == Strictness.STRICT) {
                throw new ReflectorException(e);
            }
            return null;
        }
    }

    @Override
    public List<Match> getProposals(Match match) {
        PropertiesContentAssist assist = new PropertiesContentAssist(){

            @Override
            protected ClassProperties<?> getClassProperties(Map<String, String> values) {
                String layoutName = values.get(LayoutType.LAYOUT_KEY);
                if (layoutName == null) {
                    return null;
                }
                Class<? extends Layout> layoutClass = LayoutType.this.getLayoutClass(layoutName, Strictness.NICE);
                if (layoutClass == null) {
                    return null;
                }
                return SwtInfo.LAYOUT_PROPERTIES.getProperties(layoutClass);
            }

            @Override
            protected List<Match> keyProposals(Map<String, String> values, Match match) {
                if (this.getClassProperties(values) == null) {
                    return match.propose("layout:");
                }
                return super.keyProposals(values, match);
            }

            @Override
            protected List<Match> valueProposals(Map<String, String> values, String key, Match match) {
                if (LayoutType.LAYOUT_KEY.equals(key.toLowerCase())) {
                    return match.propose(LayoutType.this.LAYOUTS);
                }
                return super.valueProposals(values, key, match);
            }
        };
        return assist.getProposals(match);
    }
}

