/*
 * Decompiled with CFR 0.152.
 */
package com.swtxml.swt.visitor;

import com.swtxml.swt.SwtInfo;
import com.swtxml.swt.metadata.WidgetTag;
import com.swtxml.tinydom.ITagVisitor;
import com.swtxml.tinydom.Tag;
import com.swtxml.util.parser.ParseException;
import com.swtxml.util.reflector.ReflectorException;
import java.lang.reflect.Constructor;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Widget;

public class BuildWidgets
implements ITagVisitor {
    private Composite parent;

    public BuildWidgets(Composite parent) {
        this.parent = parent;
    }

    @Override
    public void visit(Tag tag) {
        if (!(tag.getTagDefinition() instanceof WidgetTag)) {
            return;
        }
        if (tag.isRoot()) {
            if (!tag.getName().equals(Composite.class.getSimpleName())) {
                throw new ParseException("Invalid root tag " + tag.getName() + ", expected <" + Composite.class.getSimpleName() + ">");
            }
            tag.makeAdaptable(this.parent);
            return;
        }
        WidgetTag widgetTag = (WidgetTag)tag.getTagDefinition();
        Constructor constructor = SwtInfo.WIDGETS.getWidgetConstructor(widgetTag.getWidgetClass());
        Class<?> parentClass = constructor.getParameterTypes()[0];
        Composite parent = (Composite)tag.parentRecursiveAdaptTo(parentClass);
        Integer style = SwtInfo.SWT.getIntValue(tag.getAttribute("style"));
        Widget widget = this.build(constructor, parent, style == null ? 0 : style);
        tag.makeAdaptable(widget);
    }

    public Widget build(Constructor<?> constructor, Object parent, int style) {
        try {
            return (Widget)constructor.newInstance(parent, style);
        }
        catch (Exception e) {
            throw new ReflectorException(e);
        }
    }
}

