/*
 * Decompiled with CFR 0.152.
 */
package com.swtxml.tinydom;

import com.swtxml.adapter.IAdaptable;
import com.swtxml.definition.IAttributeDefinition;
import com.swtxml.definition.INamespaceDefinition;
import com.swtxml.definition.ITagDefinition;
import com.swtxml.definition.impl.NamespaceDefinition;
import com.swtxml.tinydom.ITagVisitor;
import com.swtxml.util.lang.ContractProof;
import com.swtxml.util.parser.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public final class Tag
implements IAdaptable {
    private final INamespaceDefinition namespaceDefinition;
    private final ITagDefinition tagDefinition;
    private final Map<INamespaceDefinition, Map<IAttributeDefinition, String>> attributeMap;
    private final Tag parent;
    private List<Tag> children;
    private final String locationInfo;
    private final List<Object> adapterObjects = new ArrayList<Object>();
    private StringBuilder characters;

    public Tag(INamespaceDefinition namespaceDefinition, ITagDefinition tagDefinition, Map<INamespaceDefinition, Map<IAttributeDefinition, String>> attributeMap, Tag parent, String locationInfo) {
        this.namespaceDefinition = namespaceDefinition;
        this.tagDefinition = tagDefinition;
        this.parent = parent;
        this.locationInfo = locationInfo;
        this.attributeMap = attributeMap;
        if (!this.isRoot()) {
            if (this.parent.children == null) {
                this.parent.children = new ArrayList<Tag>();
            }
            this.parent.children.add(this);
        }
    }

    public INamespaceDefinition getNamespaceDefinition() {
        return this.namespaceDefinition;
    }

    public ITagDefinition getTagDefinition() {
        return this.tagDefinition;
    }

    public String getName() {
        return this.tagDefinition.getName();
    }

    public String getAttribute(IAttributeDefinition attribute) {
        return this.getAttribute(this.getNamespaceDefinition(), attribute);
    }

    public String getAttribute(String attributeName) {
        return this.getAttribute(this.getNamespaceDefinition(), this.getTagDefinition().getAttribute(attributeName));
    }

    public String getAttribute(NamespaceDefinition namespace, String attributeName) {
        if (this.getNamespaceDefinition().equals(namespace)) {
            return this.getAttribute(attributeName);
        }
        return this.getAttribute((INamespaceDefinition)namespace, namespace.getForeignAttribute(attributeName));
    }

    public Collection<IAttributeDefinition> getAttributes() {
        return this.getAttributes(this.getNamespaceDefinition());
    }

    public Collection<IAttributeDefinition> getAttributes(INamespaceDefinition namespace) {
        Map<IAttributeDefinition, String> attributes = this.attributeMap.get(namespace);
        if (attributes != null) {
            return attributes.keySet();
        }
        return Collections.emptyList();
    }

    public String getAttribute(INamespaceDefinition namespace, IAttributeDefinition attribute) {
        Map<IAttributeDefinition, String> attributes = this.attributeMap.get(namespace);
        return attributes != null ? attributes.get(attribute) : null;
    }

    public Tag getParent() {
        return this.parent;
    }

    public List<Tag> getChildren() {
        if (this.children != null) {
            return this.children;
        }
        return Collections.emptyList();
    }

    public boolean isRoot() {
        return this.getParent() == null;
    }

    public String getLocationInfo() {
        return this.locationInfo;
    }

    @Override
    public <T> T adaptTo(Class<T> type) {
        for (Object adapterObject : this.adapterObjects) {
            if (!type.isAssignableFrom(adapterObject.getClass())) continue;
            return (T)adapterObject;
        }
        return (T)(type.isAssignableFrom(this.getClass()) ? this : null);
    }

    public final <T> T parentAdaptTo(Class<T> type) {
        return this.parent != null ? (T)this.parent.adaptTo(type) : null;
    }

    public final <T> T parentRecursiveAdaptTo(Class<T> type) {
        T match = this.parentAdaptTo(type);
        if (match != null) {
            return match;
        }
        if (this.parent != null) {
            return this.parent.parentAdaptTo(type);
        }
        return null;
    }

    public void makeAdaptable(Object adapterObject) {
        ContractProof.notNull(adapterObject, "adapterObject");
        this.adapterObjects.add(adapterObject);
    }

    public <T> List<T> adaptChildren(Class<T> type) {
        ArrayList<T> results = new ArrayList<T>();
        for (Tag tag : this.getChildren()) {
            T adapted = tag.adaptTo(type);
            if (adapted == null) continue;
            results.add(adapted);
        }
        return results;
    }

    public void visitDepthFirst(ITagVisitor ... visitors) {
        ITagVisitor[] iTagVisitorArray = visitors;
        int n = visitors.length;
        int n2 = 0;
        while (n2 < n) {
            ITagVisitor visitor = iTagVisitorArray[n2];
            try {
                visitor.visit(this);
            }
            catch (Exception e) {
                throw new ParseException(String.valueOf(this.getLocationInfo()) + e.getMessage(), e);
            }
            ++n2;
        }
        for (Tag child : this.getChildren()) {
            child.visitDepthFirst(visitors);
        }
    }

    public String toString() {
        return "Tag[" + this.tagDefinition + "]";
    }

    public String getCharacters() {
        return this.characters == null ? "" : this.characters.toString();
    }

    public void appendCharacters(String characters) {
        if (this.characters == null) {
            this.characters = new StringBuilder(characters);
        } else {
            this.characters.append(characters);
        }
    }
}

