/*
 * Decompiled with CFR 0.152.
 */
package com.swtxml.tinydom;

import com.swtxml.adapter.IAdaptable;
import com.swtxml.definition.INamespaceResolver;
import com.swtxml.resources.IDocumentResource;
import com.swtxml.tinydom.Tag;
import com.swtxml.tinydom.TinyDomSaxHandler;
import com.swtxml.util.parser.ParseException;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class TinyDomParser
implements IAdaptable {
    private INamespaceResolver namespaceResolver;
    protected IDocumentResource document;

    public TinyDomParser(INamespaceResolver namespaceResolver, IDocumentResource document) {
        this.namespaceResolver = namespaceResolver;
        this.document = document;
    }

    public <A> A adaptTo(Class<A> adapterClass) {
        if (IDocumentResource.class.isAssignableFrom(adapterClass)) {
            return (A)this.document;
        }
        return null;
    }

    public final <T> Tag parse() {
        SAXParserFactory parserFactory = SAXParserFactory.newInstance();
        parserFactory.setNamespaceAware(true);
        SAXParser parser = this.createSaxParser(parserFactory);
        TinyDomSaxHandler saxHandler = new TinyDomSaxHandler(this.namespaceResolver, this.document.getDocumentName());
        try {
            parser.parse(this.document.getInputSource(), (DefaultHandler)saxHandler);
        }
        catch (Exception e) {
            throw new ParseException(String.valueOf(saxHandler.getLocationInfo()) + e.getMessage(), e);
        }
        this.onParseCompleted(saxHandler.getRoot());
        return saxHandler.getRoot();
    }

    protected void onParseCompleted(Tag root) {
    }

    private SAXParser createSaxParser(SAXParserFactory parserFactory) {
        try {
            return parserFactory.newSAXParser();
        }
        catch (ParserConfigurationException e) {
            throw new ParseException(e);
        }
        catch (SAXException e) {
            throw new ParseException(e);
        }
    }
}

