/*
 * Decompiled with CFR 0.152.
 */
package com.swtxml.tinydom;

import com.swtxml.definition.IAttributeDefinition;
import com.swtxml.definition.INamespaceDefinition;
import com.swtxml.definition.INamespaceResolver;
import com.swtxml.definition.ITagDefinition;
import com.swtxml.definition.ITagScope;
import com.swtxml.tinydom.Tag;
import com.swtxml.util.lang.CollectionUtils;
import com.swtxml.util.parser.ParseException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import org.apache.commons.lang.StringUtils;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class TinyDomSaxHandler
extends DefaultHandler {
    private final String xmlFilename;
    private Locator locator;
    private Tag root;
    private final INamespaceResolver namespaceResolver;
    private final Map<String, INamespaceDefinition> namespaces = new HashMap<String, INamespaceDefinition>();
    private Stack<Tag> parserStack = new Stack();

    TinyDomSaxHandler(INamespaceResolver namespaceResolver, String xmlFilename) {
        this.namespaceResolver = namespaceResolver;
        this.xmlFilename = xmlFilename;
    }

    @Override
    public void startElement(String namespace, String localName, String qName, Attributes attributes) throws SAXException {
        ITagDefinition parentTag;
        INamespaceDefinition namespaceDefinition = this.getNamespace(namespace);
        ITagDefinition tagDefinition = namespaceDefinition.getTag(localName);
        if (tagDefinition == null) {
            throw new ParseException("Unknown tag \"" + localName + "\" for namespace \"" + namespace + "\", allowed are: " + CollectionUtils.sortedToString(namespaceDefinition.getTagNames()));
        }
        Map<INamespaceDefinition, Map<IAttributeDefinition, String>> attributeMap = this.processAttributes(namespaceDefinition, tagDefinition, attributes);
        Tag tag = new Tag(namespaceDefinition, tagDefinition, attributeMap, this.parserStack.isEmpty() ? null : this.parserStack.peek(), this.getLocationInfo());
        ITagDefinition iTagDefinition = parentTag = tag.getParent() != null ? tag.getParent().getTagDefinition() : ITagDefinition.ROOT;
        if (tagDefinition instanceof ITagScope && !((ITagScope)((Object)tagDefinition)).isAllowedIn(parentTag)) {
            throw new ParseException("Tag " + tag.getName() + " is not allowed in " + parentTag.getName());
        }
        if (this.root == null) {
            this.root = tag;
        }
        this.parserStack.push(tag);
    }

    @Override
    public synchronized void characters(char[] cbuf, int start, int len) {
        Tag tag;
        Tag tag2 = tag = this.parserStack.isEmpty() ? null : this.parserStack.peek();
        if (tag == null) {
            return;
        }
        tag.appendCharacters(new String(cbuf, start, len));
    }

    private Map<INamespaceDefinition, Map<IAttributeDefinition, String>> processAttributes(INamespaceDefinition tagNamespace, ITagDefinition tagDefinition, Attributes attributes) {
        HashMap<INamespaceDefinition, Map<IAttributeDefinition, String>> attributeNsMap = new HashMap<INamespaceDefinition, Map<IAttributeDefinition, String>>();
        int i = 0;
        while (i < attributes.getLength()) {
            IAttributeDefinition attributeDefinition;
            String uri = attributes.getURI(i);
            INamespaceDefinition attributeNamespace = !StringUtils.isEmpty((String)uri) ? this.getNamespace(uri) : tagNamespace;
            HashMap<IAttributeDefinition, String> attributeMap = (HashMap<IAttributeDefinition, String>)attributeNsMap.get(attributeNamespace);
            if (attributeMap == null) {
                attributeMap = new HashMap<IAttributeDefinition, String>();
                attributeNsMap.put(attributeNamespace, attributeMap);
            }
            String name = attributes.getLocalName(i);
            String value = attributes.getValue(i);
            if (attributeNamespace.equals(tagNamespace)) {
                attributeDefinition = tagDefinition.getAttribute(name);
            } else {
                attributeDefinition = attributeNamespace.getForeignAttribute(name);
                if (attributeDefinition instanceof ITagScope && !((ITagScope)((Object)attributeDefinition)).isAllowedIn(tagDefinition)) {
                    throw new ParseException("Attribute " + attributes.getQName(i) + " is not allowed for tag \"" + tagDefinition.getName() + "\"");
                }
            }
            if (attributeDefinition == null) {
                throw new ParseException("Unknown attribute \"" + attributes.getQName(i) + "\" for tag \"" + tagDefinition.getName() + "\" (available are: " + CollectionUtils.sortedToString(tagDefinition.getAttributeNames()) + ")");
            }
            attributeMap.put(attributeDefinition, value);
            ++i;
        }
        if (attributeNsMap.isEmpty()) {
            return Collections.emptyMap();
        }
        return attributeNsMap;
    }

    private INamespaceDefinition getNamespace(String namespaceUri) {
        INamespaceDefinition namespace = this.namespaces.get(namespaceUri);
        if (namespace == null) {
            namespace = this.namespaceResolver.resolveNamespace(namespaceUri);
            if (namespace == null) {
                throw new ParseException("Unknown namespace: " + namespaceUri);
            }
            this.namespaces.put(namespaceUri, namespace);
        }
        return namespace;
    }

    public String getLocationInfo() {
        return String.valueOf(this.xmlFilename) + (this.locator != null ? " [line " + this.locator.getLineNumber() + "] " : "");
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        this.parserStack.pop();
    }

    @Override
    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
    }

    public Tag getRoot() {
        return this.root;
    }
}

