/*
 * Decompiled with CFR 0.152.
 */
package com.swtxml.util.context;

import com.swtxml.adapter.IAdaptable;
import java.util.ArrayList;
import java.util.List;

public class Context {
    private static final ThreadLocal<Context> context = new ThreadLocal();
    private final List<IAdaptable> adapters;

    Context() {
        this.adapters = new ArrayList<IAdaptable>();
    }

    Context(Context ctx) {
        this.adapters = new ArrayList<IAdaptable>(ctx.adapters);
    }

    public static void dump() {
        System.out.println(context.get());
    }

    public static <A> A adaptTo(Class<A> clazz) {
        Context ctx = context.get();
        if (ctx == null) {
            return null;
        }
        for (IAdaptable adapter : ctx.adapters) {
            A obj = null;
            try {
                obj = adapter.adaptTo(clazz);
            }
            catch (Exception exception) {}
            if (obj == null) continue;
            return obj;
        }
        return null;
    }

    public static void addAdapter(IAdaptable adapter) {
        Context ctx = context.get();
        if (ctx == null) {
            ctx = new Context();
            context.set(ctx);
        }
        ctx.adapters.add(adapter);
    }

    public static void runWith(Runnable runnable) {
        Context oldContext = context.get();
        if (oldContext != null) {
            context.set(new Context(oldContext));
        }
        try {
            runnable.run();
        }
        finally {
            context.set(oldContext);
        }
    }

    public static void clear() {
        context.set(null);
    }

    public String toString() {
        return "Context[" + this.adapters + "]";
    }
}

