/*
 * Decompiled with CFR 0.152.
 */
package com.swtxml.util.lang;

import com.swtxml.util.lang.Functions;
import com.swtxml.util.lang.IFilter;
import com.swtxml.util.lang.IFunction;
import com.swtxml.util.reflector.ReflectorException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.StringUtils;

public class CollectionUtils {
    public static <A> A find(Iterable<? extends A> iterable, IFilter<A> filter) {
        for (A a : iterable) {
            if (!filter.match(a)) continue;
            return a;
        }
        return null;
    }

    public static <A> Collection<A> select(Collection<? extends A> collection, IFilter<A> filter) {
        Collection resultList = CollectionUtils.createCollection(collection);
        for (A a : collection) {
            if (!filter.match(a)) continue;
            resultList.add(a);
        }
        return resultList;
    }

    public static <FROM, TO> Collection<TO> collect(Collection<? extends FROM> collection, IFunction<FROM, TO> function) {
        Collection resultList = CollectionUtils.createCollection(collection);
        for (FROM a : collection) {
            resultList.add(function.apply(a));
        }
        return resultList;
    }

    public static <FROM, TO> List<TO> collect(List<? extends FROM> list, IFunction<FROM, TO> function) {
        ArrayList<TO> resultList = new ArrayList<TO>();
        for (FROM a : list) {
            resultList.add(function.apply(a));
        }
        return resultList;
    }

    public static String sortedToString(Collection<?> collection) {
        ArrayList<String> strings = new ArrayList<String>(CollectionUtils.collect(collection, Functions.TO_STRING));
        Collections.sort(strings);
        return StringUtils.join(strings, (String)", ");
    }

    private static Collection createCollection(Collection original) {
        if (original instanceof Set) {
            return new HashSet();
        }
        if (original instanceof Collection) {
            return new ArrayList();
        }
        throw new ReflectorException("Unknown collection type: " + original.getClass());
    }
}

