/*
 * Decompiled with CFR 0.152.
 */
package com.swtxml.util.lang;

import com.swtxml.util.lang.RuntimeIOException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;

public class ResourceUtils {
    public static String toString(InputStream input) {
        try {
            StringWriter writer = new StringWriter();
            InputStreamReader in = new InputStreamReader(input);
            char[] buffer = new char[2048];
            int i = 0;
            while ((i = in.read(buffer)) > 0) {
                writer.write(buffer, 0, i);
            }
            input.close();
            return writer.toString();
        }
        catch (IOException e) {
            throw new RuntimeIOException(e.getMessage(), e);
        }
    }

    public static InputStream getClassResource(Class<?> clazz, String extension) {
        String fname = String.valueOf(clazz.getSimpleName()) + "." + extension;
        InputStream resource = clazz.getResourceAsStream(fname);
        if (resource == null) {
            throw new RuntimeIOException(String.valueOf(fname) + " not found in package " + clazz.getPackage().getName());
        }
        return resource;
    }
}

