/*
 * Decompiled with CFR 0.152.
 */
package com.swtxml.util.parser;

import com.swtxml.util.parser.ParseException;
import com.swtxml.util.parser.Splitter;
import com.swtxml.util.reflector.Reflector;
import com.swtxml.util.reflector.ReflectorException;
import com.swtxml.util.reflector.Subclasses;
import com.swtxml.util.reflector.Visibility;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class ConstantParser {
    private Map<String, Integer> constantMap = new HashMap<String, Integer>();
    public static final Splitter SPLITTER = new Splitter(",;|");

    public ConstantParser(Class<?> ... constantClasses) {
        Class<?>[] classArray = constantClasses;
        int n = constantClasses.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> cl = classArray[n2];
            if (!this.constantMap.containsKey(cl)) {
                this.constantMap.putAll(this.extractConstants(cl));
            }
            ++n2;
        }
    }

    private ConstantParser(Map<String, Integer> constantMap) {
        this.constantMap = constantMap;
    }

    private Map<String, Integer> extractConstants(Class<?> cl) {
        HashMap<String, Integer> constants = new HashMap<String, Integer>();
        try {
            Collection<Field> fields = Reflector.findFields(Visibility.PUBLIC, Subclasses.NONE).isStatic(true).type(Integer.TYPE).all(cl);
            for (Field field : fields) {
                constants.put(field.getName(), field.getInt(cl));
            }
        }
        catch (Exception e) {
            throw new ReflectorException(e);
        }
        return constants;
    }

    public int getIntValue(String value) {
        String[] values;
        int style = 0;
        if (value == null) {
            return style;
        }
        String[] stringArray = values = SPLITTER.split(value);
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            String v = stringArray[n2];
            v = v.trim().toUpperCase();
            Integer constant = null;
            constant = this.constantMap.get(v);
            if (constant == null) {
                ArrayList<String> constants = new ArrayList<String>(this.constantMap.keySet());
                Collections.sort(constants);
                throw new ParseException("Unknown style constant: " + v + ", allowed are: " + SPLITTER.join(constants));
            }
            style |= constant.intValue();
            ++n2;
        }
        return style;
    }

    public ConstantParser filter(String value) {
        return this.filter(Arrays.asList(SPLITTER.split(value)));
    }

    public ConstantParser filter(Iterable<String> values) {
        HashMap<String, Integer> matches = new HashMap<String, Integer>();
        for (String v : values) {
            v = v.trim().toUpperCase();
            Integer constant = null;
            constant = this.constantMap.get(v);
            if (constant == null) {
                ArrayList<String> constants = new ArrayList<String>(this.constantMap.keySet());
                Collections.sort(constants);
                throw new ParseException("Unknown style constant: " + v + ", allowed are: " + StringUtils.join(constants, (String)", "));
            }
            matches.put(v, constant);
        }
        return new ConstantParser(matches);
    }

    public Collection<String> getConstants() {
        return this.constantMap.keySet();
    }
}

