/*
 * Decompiled with CFR 0.152.
 */
package com.swtxml.util.parser;

import com.swtxml.util.parser.ParseException;
import com.swtxml.util.parser.Splitter;
import com.swtxml.util.parser.Strictness;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class KeyValueParser {
    public static final Splitter VALUE_SPLITTER = new Splitter(";");
    public static final Splitter KEY_VALUE_SPLITTER = new Splitter(":");

    public static Map<String, String> parse(String value) {
        return KeyValueParser.parse(value, Strictness.STRICT);
    }

    public static Map<String, String> parse(String value, boolean trimValue) {
        return KeyValueParser.parse(value, Strictness.STRICT, trimValue);
    }

    public static Map<String, String> parse(String value, Strictness strictness) {
        return KeyValueParser.parse(value, Strictness.STRICT, true);
    }

    public static Map<String, String> parse(String value, Strictness strictness, boolean trimValue) {
        HashMap<String, String> values = new HashMap<String, String>();
        String[] stringArray = VALUE_SPLITTER.split(value);
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String valuePair = stringArray[n2];
            if (StringUtils.isNotBlank((String)valuePair)) {
                String[] keyValue = KEY_VALUE_SPLITTER.split(valuePair);
                if (keyValue.length != 2) {
                    if (strictness == Strictness.STRICT) {
                        throw new ParseException("Invalid format: \"" + valuePair + "\" ");
                    }
                    if (keyValue.length == 1) {
                        keyValue = new String[]{keyValue[0], ""};
                    }
                }
                values.put(keyValue[0].trim(), trimValue ? keyValue[1].trim() : keyValue[1]);
            }
            ++n2;
        }
        return values;
    }
}

