/*
 * Decompiled with CFR 0.152.
 */
package com.swtxml.util.properties;

import com.swtxml.util.lang.CollectionUtils;
import com.swtxml.util.properties.IInjector;
import com.swtxml.util.properties.PropertiesException;
import com.swtxml.util.properties.Property;
import com.swtxml.util.properties.PropertyMatcher;
import com.swtxml.util.reflector.IReflectorProperty;
import com.swtxml.util.reflector.ReflectorBean;
import com.swtxml.util.types.IType;
import java.util.HashMap;
import java.util.Map;

public class ClassProperties<A> {
    private Map<String, Property> properties = new HashMap<String, Property>();

    ClassProperties(ReflectorBean bean, Map<PropertyMatcher, IType<?>> propertyTypes) {
        for (IReflectorProperty prop : bean.getProperties()) {
            Property property = null;
            for (PropertyMatcher matcher : propertyTypes.keySet()) {
                if (!matcher.match(bean.getType(), prop.getName(), prop.getType())) continue;
                property = new Property(prop, propertyTypes.get(matcher));
                break;
            }
            if (property == null) continue;
            this.properties.put(property.getName(), property);
        }
    }

    public IInjector getInjector(final Object obj) {
        return new IInjector(){

            @Override
            public void setPropertyValue(String name, String value) {
                Property property = ClassProperties.this.properties.get(name);
                if (property == null) {
                    throw new PropertiesException("Unknown property \"" + name + "\" (available are: " + CollectionUtils.sortedToString(ClassProperties.this.properties.keySet()) + ")");
                }
                property.set(obj, value);
            }

            @Override
            public void setPropertyValues(Map<String, String> values) {
                for (String name : values.keySet()) {
                    this.setPropertyValue(name, values.get(name));
                }
            }
        };
    }

    public Map<String, Property> getProperties() {
        return this.properties;
    }

    public String toString() {
        return "ClassProperties[" + this.properties + "]";
    }
}

