/*
 * Decompiled with CFR 0.152.
 */
package com.swtxml.util.properties;

import com.swtxml.util.lang.CollectionUtils;
import com.swtxml.util.lang.IFunction;
import com.swtxml.util.parser.KeyValueContentAssist;
import com.swtxml.util.properties.ClassProperties;
import com.swtxml.util.properties.Property;
import com.swtxml.util.proposals.Match;
import com.swtxml.util.types.IContentAssistable;
import com.swtxml.util.types.IType;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public abstract class PropertiesContentAssist
extends KeyValueContentAssist {
    @Override
    protected List<Match> keyProposals(Map<String, String> values, Match match) {
        ClassProperties<?> properties = this.getClassProperties(values);
        if (properties == null) {
            return Collections.emptyList();
        }
        HashSet<String> propertyNames = new HashSet<String>(properties.getProperties().keySet());
        propertyNames.removeAll(values.keySet());
        Collection<String> propertyProposals = CollectionUtils.collect(propertyNames, new IFunction<String, String>(){

            @Override
            public String apply(String s) {
                return String.valueOf(s) + ":";
            }
        });
        return match.propose(propertyProposals);
    }

    @Override
    protected List<Match> valueProposals(Map<String, String> values, String key, Match match) {
        IType<?> type;
        ClassProperties<?> properties = this.getClassProperties(values);
        if (properties == null) {
            return Collections.emptyList();
        }
        Property property = properties.getProperties().get(key);
        if (property != null && (type = property.getType()) instanceof IContentAssistable) {
            List<Match> proposals = ((IContentAssistable)((Object)type)).getProposals(match);
            for (Match proposal : proposals) {
                proposal.moveCursor(1);
            }
            return proposals;
        }
        return Collections.emptyList();
    }

    protected abstract ClassProperties<?> getClassProperties(Map<String, String> var1);
}

