/*
 * Decompiled with CFR 0.152.
 */
package com.swtxml.util.properties;

import com.swtxml.util.properties.PropertiesException;
import java.util.Arrays;
import org.apache.commons.lang.ArrayUtils;

public class PropertyMatcher {
    public static final Class<?> ALL_CLASSES = null;
    public static final String ALL_PROPERTIES = null;
    private final Class<?> forClass;
    private final String propertyName;
    private final Class<?>[] targetTypes;

    public PropertyMatcher(Class<?> ... propertyTypes) {
        this(ALL_CLASSES, ALL_PROPERTIES, propertyTypes);
    }

    public PropertyMatcher(Class<?> forClass, String propertyName, Class<?> ... propertyTypes) {
        this.forClass = forClass;
        this.propertyName = propertyName;
        this.targetTypes = propertyTypes;
        Class<?>[] classArray = propertyTypes;
        int n = propertyTypes.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> type = classArray[n2];
            if (type == null) {
                throw new PropertiesException("propertyTypes may not be null");
            }
            ++n2;
        }
    }

    public boolean match(Class<?> queryClass, String queryPropertyName, Class<?> queryTargetType) {
        if (this.forClass != null && !this.forClass.isAssignableFrom(queryClass)) {
            return false;
        }
        if (this.propertyName != null && !this.propertyName.equals(queryPropertyName)) {
            return false;
        }
        return this.targetTypes.length <= 0 || ArrayUtils.contains((Object[])this.targetTypes, queryTargetType);
    }

    public String toString() {
        String classLabel = this.forClass != null ? this.forClass.getSimpleName() : "*";
        String propLabel = this.propertyName != null ? this.propertyName : "*";
        String targetTypesLabel = this.targetTypes.length > 0 ? Arrays.toString(this.targetTypes) : "*";
        return "PropertyMatcher[" + classLabel + "." + propLabel + " = " + targetTypesLabel + "]";
    }
}

