/*
 * Decompiled with CFR 0.152.
 */
package com.swtxml.util.proposals;

import com.swtxml.util.lang.CollectionUtils;
import com.swtxml.util.lang.IFilter;
import com.swtxml.util.parser.ParseException;
import com.swtxml.util.parser.Splitter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class Match {
    private int cursorPos;
    private String text;
    private int start;
    private int end;

    public Match(String text, int cursorPos) {
        this.text = text;
        this.cursorPos = cursorPos;
        this.start = 0;
        this.end = text.length();
    }

    public Match(String str) {
        this.cursorPos = str.indexOf(65533);
        if (this.cursorPos < 0) {
            throw new ParseException("No cursor char \ufffd given");
        }
        this.text = String.valueOf(str.substring(0, this.cursorPos)) + str.substring(this.cursorPos + 1);
        this.start = 0;
        this.end = this.text.length();
    }

    public Match(Match m) {
        this.cursorPos = m.cursorPos;
        this.text = m.text;
        this.start = m.start;
        this.end = m.end;
    }

    public int getReplacementCursorPos() {
        return this.cursorPos;
    }

    public int getCursorPos() {
        return this.cursorPos - this.start;
    }

    public String getText() {
        return this.text.substring(this.start, this.end);
    }

    public String toString() {
        return String.valueOf(this.text.substring(0, this.cursorPos)) + "\ufffd" + this.text.substring(this.cursorPos);
    }

    private void _handleQuotes() {
        if (!this.text.startsWith("\"")) {
            this._insertAroundMatch("\"", "");
        } else {
            ++this.start;
        }
        if (!this.text.endsWith("\"")) {
            this._insertAroundMatch("", "\"");
        } else {
            --this.end;
        }
    }

    public Match handleQuotes() {
        Match m = new Match(this);
        m._handleQuotes();
        return m;
    }

    public Match insert(String str, int i) {
        Match m = new Match(this);
        m._insert(str, i);
        return m;
    }

    public Match replace(String str) {
        Match m = new Match(this);
        m._replace(str, 0, this.getText().length());
        return m;
    }

    public Match replace(String str, int i, int length) {
        Match m = new Match(this);
        m._replace(str, i, length);
        return m;
    }

    public Match restrict(Splitter splitter) {
        Match m = new Match(this);
        m._restrict(splitter);
        return m;
    }

    private void _insert(String str, int i) {
        this._replace(str, i, 0);
    }

    private void _replace(String str, int i, int length) {
        if ((i += this.start) + length < this.cursorPos) {
            this.cursorPos -= length - str.length();
        }
        if (i <= this.cursorPos && this.cursorPos <= i + length) {
            this.cursorPos = i + str.length();
        }
        this.end -= length - str.length();
        this.text = String.valueOf(this.text.substring(0, i)) + str + this.text.substring(i + length);
    }

    public Match insertAroundMatch(String startstr, String endstr) {
        Match m = new Match(this);
        m._insertAroundMatch(startstr, endstr);
        return m;
    }

    private void _insertAroundMatch(String startstr, String endstr) {
        this.text = String.valueOf(this.text.substring(0, this.start)) + startstr + this.text.substring(this.start, this.end) + endstr + this.text.substring(this.end);
        this.start += startstr.length();
        this.end += startstr.length();
        this.cursorPos += startstr.length();
    }

    public String getReplacementText() {
        return this.text;
    }

    public List<Match> propose(String ... values) {
        return this.propose(Arrays.asList(values));
    }

    private void _restrict(Splitter splitter) {
        splitter.getSeparators();
        int i = this.cursorPos - 1;
        while (i >= this.start) {
            if (splitter.isSeparator(this.text.charAt(i))) {
                this.start = i + 1;
                break;
            }
            --i;
        }
        i = this.cursorPos;
        while (i < this.end) {
            if (splitter.isSeparator(this.text.charAt(i))) {
                this.end = i;
                break;
            }
            ++i;
        }
    }

    public List<Match> propose(Collection<String> values) {
        final String textBeforeCursor = this.getTextBeforeCursor().toLowerCase().trim();
        ArrayList<String> filteredValues = new ArrayList<String>(CollectionUtils.select(values, new IFilter<String>(){

            @Override
            public boolean match(String value) {
                return value.toLowerCase().startsWith(textBeforeCursor);
            }
        }));
        Collections.sort(filteredValues);
        ArrayList<Match> resultMatches = new ArrayList<Match>();
        for (String value : filteredValues) {
            resultMatches.add(this.replace(value));
        }
        return resultMatches;
    }

    public String getTextBeforeCursor() {
        if (this.cursorPos <= this.start) {
            return "";
        }
        return this.text.substring(this.start, this.cursorPos);
    }

    public void dump() {
        System.out.println(this.text);
        System.out.println(String.valueOf(StringUtils.leftPad((String)"[", (int)(this.start + 1))) + StringUtils.leftPad((String)"]", (int)(this.end - this.start)));
        System.out.println(StringUtils.leftPad((String)"C", (int)(this.cursorPos + 1)));
    }

    public void moveCursor(int i) {
        this.cursorPos += i;
    }
}

