/*
 * Decompiled with CFR 0.152.
 */
package com.swtxml.util.reflector;

import com.swtxml.util.lang.CollectionUtils;
import com.swtxml.util.lang.Filters;
import com.swtxml.util.lang.IFilter;
import com.swtxml.util.reflector.ReflectorException;
import com.swtxml.util.reflector.Subclasses;
import com.swtxml.util.reflector.Visibility;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class FieldQuery {
    private Visibility visibility;
    private Subclasses subclasses;
    private List<IFilter<Field>> filters = new ArrayList<IFilter<Field>>();

    FieldQuery(Visibility visibility, Subclasses subclasses) {
        this.visibility = visibility;
        this.subclasses = subclasses;
    }

    private Collection<Field> getFields(Class<?> type) {
        if (this.visibility == Visibility.PUBLIC && this.subclasses == Subclasses.INCLUDE) {
            return Arrays.asList(type.getFields());
        }
        if (this.visibility == Visibility.PUBLIC && this.subclasses == Subclasses.NONE) {
            List<Field> fields = Arrays.asList(type.getDeclaredFields());
            Iterator<Field> i = fields.iterator();
            while (i.hasNext()) {
                if (Modifier.isPublic(i.next().getModifiers())) continue;
                i.remove();
            }
            return fields;
        }
        if (this.visibility == Visibility.PRIVATE && this.subclasses == Subclasses.INCLUDE) {
            return this.getAllFields(type);
        }
        throw new UnsupportedOperationException("Querying with " + (Object)((Object)this.visibility) + " and " + (Object)((Object)this.subclasses) + " not supported at the moment.");
    }

    public FieldQuery name(final String name) {
        this.filters.add(new IFilter<Field>(){

            @Override
            public boolean match(Field field) {
                return field.getName().equals(name);
            }
        });
        return this;
    }

    public FieldQuery nameStartsWith(final String str) {
        this.filters.add(new IFilter<Field>(){

            @Override
            public boolean match(Field field) {
                return field.getName().startsWith(str);
            }
        });
        return this;
    }

    public FieldQuery annotatedWith(final Class<? extends Annotation> annotationClass) {
        this.filters.add(new IFilter<Field>(){

            @Override
            public boolean match(Field field) {
                return field.isAnnotationPresent(annotationClass);
            }
        });
        return this;
    }

    public FieldQuery type(final Class<?> type) {
        this.filters.add(new IFilter<Field>(){

            @Override
            public boolean match(Field field) {
                return type.equals(field.getType());
            }
        });
        return this;
    }

    public FieldQuery isStatic(final boolean isStatic) {
        this.filters.add(new IFilter<Field>(){

            @Override
            public boolean match(Field field) {
                return isStatic == Modifier.isStatic(field.getModifiers());
            }
        });
        return this;
    }

    public Collection<Field> all(Class<?> type) {
        return CollectionUtils.select(this.getFields(type), Filters.and(this.filters));
    }

    public Field exactOne(Class<?> type) {
        Collection<Field> results = this.all(type);
        if (results.size() == 1) {
            return results.iterator().next();
        }
        if (results.isEmpty()) {
            throw new ReflectorException("No suitable fields found for query!");
        }
        throw new ReflectorException("Ambiguous fields found for query!");
    }

    private Collection<Field> getAllFields(Class<?> type) {
        ArrayList<Field> fields = new ArrayList<Field>();
        while (type != null) {
            Field[] fieldArray = type.getDeclaredFields();
            int n = fieldArray.length;
            int n2 = 0;
            while (n2 < n) {
                Field field = fieldArray[n2];
                if (!field.isSynthetic()) {
                    fields.add(field);
                }
                ++n2;
            }
            type = type.getSuperclass();
        }
        return fields;
    }
}

