/*
 * Decompiled with CFR 0.152.
 */
package com.swtxml.util.reflector;

import com.swtxml.util.lang.CollectionUtils;
import com.swtxml.util.lang.ContractProof;
import com.swtxml.util.lang.Filters;
import com.swtxml.util.lang.IFilter;
import com.swtxml.util.reflector.ReflectorException;
import com.swtxml.util.reflector.Subclasses;
import com.swtxml.util.reflector.Visibility;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang.ObjectUtils;

public class MethodQuery {
    private Visibility visibility;
    private Subclasses subclasses;
    private List<IFilter<Method>> filters = new ArrayList<IFilter<Method>>();
    public static final Class<?> ANY_TYPE = AnyType.class;

    MethodQuery(Visibility visibility, Subclasses subclasses) {
        this.visibility = visibility;
        this.subclasses = subclasses;
    }

    private Collection<Method> getMethods(Class<?> type) {
        if (this.visibility == Visibility.PUBLIC && this.subclasses == Subclasses.INCLUDE) {
            return Arrays.asList(type.getMethods());
        }
        if (this.visibility == Visibility.PRIVATE && this.subclasses == Subclasses.INCLUDE) {
            return this.getAllMethods(type);
        }
        throw new UnsupportedOperationException("Querying with " + (Object)((Object)this.visibility) + " and " + (Object)((Object)this.subclasses) + " not supported at the moment.");
    }

    public MethodQuery nameStartsWith(final String str) {
        this.filters.add(new IFilter<Method>(){

            @Override
            public boolean match(Method method) {
                return method.getName().startsWith(str);
            }

            public String toString() {
                return "name starts with \"" + str + "\"";
            }
        });
        return this;
    }

    public MethodQuery nameMatches(final String regex) {
        this.filters.add(new IFilter<Method>(){

            @Override
            public boolean match(Method method) {
                return method.getName().matches(regex);
            }

            public String toString() {
                return "name matches \"" + regex + "\"";
            }
        });
        return this;
    }

    public MethodQuery parameters(final Class<?> ... signature) {
        this.filters.add(new IFilter<Method>(){

            @Override
            public boolean match(Method method) {
                if (method.getParameterTypes().length != signature.length) {
                    return false;
                }
                int i = 0;
                while (i < signature.length) {
                    if (!AnyType.class.isAssignableFrom(signature[i]) && !signature[i].isAssignableFrom(method.getParameterTypes()[i])) {
                        return false;
                    }
                    ++i;
                }
                return true;
            }

            public String toString() {
                return "parameters=\"" + Arrays.toString(signature) + "\"";
            }
        });
        return this;
    }

    public Collection<Method> all(Class<?> type) {
        return CollectionUtils.select(this.getMethods(type), this.getFilter());
    }

    private IFilter<Method> getFilter() {
        return Filters.and(this.filters);
    }

    public MethodQuery name(final String name) {
        this.filters.add(new IFilter<Method>(){

            @Override
            public boolean match(Method method) {
                return method.getName().equals(name);
            }

            public String toString() {
                return "name=\"" + name + "\"";
            }
        });
        return this;
    }

    public Method exactOne(Class<?> type) {
        Collection<Method> results = this.all(type);
        if (results.size() == 1) {
            return results.iterator().next();
        }
        if (results.isEmpty()) {
            throw new ReflectorException("No method " + this.getFilter() + " found in " + type + "!");
        }
        throw new ReflectorException("Ambiguous methods found for " + this.getFilter() + " in " + type + ": " + results);
    }

    public MethodQuery optionalParameter(final Class<?> type) {
        ContractProof.notNull(type, "type");
        this.filters.add(new IFilter<Method>(){

            @Override
            public boolean match(Method method) {
                return method.getParameterTypes().length == 0 || method.getParameterTypes().length == 1 && type == method.getParameterTypes()[0];
            }

            public String toString() {
                return "optional parameter \"" + type.getSimpleName() + "\"";
            }
        });
        return this;
    }

    public MethodQuery returnType(final Class<?> type) {
        this.filters.add(new IFilter<Method>(){

            @Override
            public boolean match(Method method) {
                return ObjectUtils.equals((Object)type, method.getReturnType());
            }

            public String toString() {
                return "return type \"" + (type != null ? type.getSimpleName() : "null") + "\"";
            }
        });
        return this;
    }

    private Collection<Method> getAllMethods(Class<?> type) {
        HashMap<String, Method> signatureToMethod = new HashMap<String, Method>();
        while (type != null) {
            Method[] methodArray = type.getDeclaredMethods();
            int n = methodArray.length;
            int n2 = 0;
            while (n2 < n) {
                String signature;
                Method method = methodArray[n2];
                if (!(method.isBridge() || method.isSynthetic() || signatureToMethod.containsKey(signature = this.getSignature(method)))) {
                    signatureToMethod.put(signature, method);
                }
                ++n2;
            }
            type = type.getSuperclass();
        }
        return signatureToMethod.values();
    }

    private String getSignature(Method method) {
        StringBuffer s = new StringBuffer();
        s.append(method.getName());
        Class<?>[] classArray = method.getParameterTypes();
        int n = classArray.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> param = classArray[n2];
            s.append(':');
            s.append(param.getName());
            ++n2;
        }
        return s.toString();
    }

    private static class AnyType {
        private AnyType() {
        }
    }
}

