/*
 * Decompiled with CFR 0.152.
 */
package com.swtxml.util.reflector;

import com.swtxml.util.reflector.FieldQuery;
import com.swtxml.util.reflector.IReflectorProperty;
import com.swtxml.util.reflector.MethodQuery;
import com.swtxml.util.reflector.PublicFields;
import com.swtxml.util.reflector.ReflectorField;
import com.swtxml.util.reflector.ReflectorProperty;
import com.swtxml.util.reflector.Subclasses;
import com.swtxml.util.reflector.Visibility;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;

public class Reflector {
    public static MethodQuery findMethods(Visibility visibility, Subclasses subclasses) {
        return new MethodQuery(visibility, subclasses);
    }

    public static FieldQuery findFields(Visibility visibility, Subclasses subclasses) {
        return new FieldQuery(visibility, subclasses);
    }

    static Collection<Method> findPublicSetters(Class<?> cl) {
        return Reflector.findMethods(Visibility.PUBLIC, Subclasses.INCLUDE).nameStartsWith("set").parameters(MethodQuery.ANY_TYPE).all(cl);
    }

    public static Collection<IReflectorProperty> findPublicProperties(Class<?> cl, PublicFields publicFields) {
        ArrayList<IReflectorProperty> properties = new ArrayList<IReflectorProperty>();
        Collection<Method> setters = Reflector.findPublicSetters(cl);
        for (Method setter : setters) {
            Collection<Method> getters = Reflector.findMethods(Visibility.PUBLIC, Subclasses.INCLUDE).name("g" + setter.getName().substring(1)).parameters(new Class[0]).returnType(setter.getParameterTypes()[0]).all(cl);
            if (getters.size() != 1) continue;
            properties.add(new ReflectorProperty(getters.iterator().next(), setter));
        }
        if (PublicFields.INCLUDE == publicFields) {
            Collection<Field> fields = Reflector.findFields(Visibility.PUBLIC, Subclasses.INCLUDE).isStatic(false).all(cl);
            for (Field f : fields) {
                properties.add(new ReflectorField(f));
            }
        }
        return properties;
    }
}

