/*
 * Decompiled with CFR 0.152.
 */
package com.swtxml.util.reflector;

import com.swtxml.util.lang.ContractProof;
import com.swtxml.util.reflector.IReflectorProperty;
import com.swtxml.util.reflector.PublicFields;
import com.swtxml.util.reflector.Reflector;
import java.util.Collection;
import java.util.Collections;

public class ReflectorBean {
    private Collection<IReflectorProperty> properties;
    private final Class<?> type;

    public Class<?> getType() {
        return this.type;
    }

    public ReflectorBean(Class<?> type, PublicFields publicFields) {
        ContractProof.notNull(type, "type");
        this.type = type;
        this.properties = Collections.unmodifiableCollection(Reflector.findPublicProperties(type, publicFields));
    }

    public IReflectorProperty getProperty(String propertyName) {
        for (IReflectorProperty property : this.properties) {
            if (!propertyName.equals(property.getName())) continue;
            return property;
        }
        return null;
    }

    public Collection<IReflectorProperty> getProperties() {
        return this.properties;
    }

    public String toString() {
        return "ReflectorBean[" + this.getName() + "]";
    }

    public String getName() {
        return this.type.getSimpleName();
    }
}

