/*
 * Decompiled with CFR 0.152.
 */
package com.swtxml.util.reflector;

import com.swtxml.util.reflector.IReflectorProperty;
import com.swtxml.util.reflector.ReflectorException;
import java.lang.reflect.Method;

class ReflectorProperty
implements IReflectorProperty {
    private final Method getter;
    private final Method setter;

    public ReflectorProperty(Method getter, Method setter) {
        this.getter = getter;
        this.setter = setter;
    }

    @Override
    public String getName() {
        String n = this.getter.getName().substring(3);
        return String.valueOf(n.substring(0, 1).toLowerCase()) + n.substring(1);
    }

    public Method getGetter() {
        return this.getter;
    }

    public Method getSetter() {
        return this.setter;
    }

    @Override
    public void set(Object obj, Object value) {
        try {
            this.setter.invoke(obj, value);
        }
        catch (Exception e) {
            throw new ReflectorException(e);
        }
    }

    @Override
    public Class<?> getType() {
        return this.getter.getReturnType();
    }

    @Override
    public Object get(Object obj) {
        try {
            return this.getter.invoke(obj, new Object[0]);
        }
        catch (Exception e) {
            throw new ReflectorException(e);
        }
    }

    public String toString() {
        return "ReflectorProperty[" + this.getType() + " " + this.getName() + "]";
    }
}

