/*
 * Decompiled with CFR 0.152.
 */
package com.swtxml.util.types;

import com.swtxml.util.properties.PropertyMatcher;
import com.swtxml.util.properties.PropertyRegistry;
import com.swtxml.util.proposals.Match;
import com.swtxml.util.types.IContentAssistable;
import com.swtxml.util.types.IType;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class SimpleTypes {
    public static final IType<String> STRING = new StringType();
    public static final IType<Boolean> BOOLEAN = new BooleanType();
    public static final IType<Integer> INTEGER = new IntegerType();
    public static final IType<Float> FLOAT = new FloatType();
    public static final IType<Character> CHARACTER = new CharacterType();
    public static final IType<int[]> INT_ARRAY = new IntArrayType();
    public static final IType<String[]> STRING_ARRAY = new StringArrayType();

    public static void addSimpleTypes(PropertyRegistry inj) {
        inj.add(new PropertyMatcher(Boolean.class, Boolean.TYPE), BOOLEAN);
        inj.add(new PropertyMatcher(Integer.class, Integer.TYPE), INTEGER);
        inj.add(new PropertyMatcher(Float.class, Float.TYPE), FLOAT);
        inj.add(new PropertyMatcher(Character.class, Character.TYPE), CHARACTER);
        inj.add(new PropertyMatcher(String.class), STRING);
        inj.add(new PropertyMatcher(String[].class), STRING_ARRAY);
        inj.add(new PropertyMatcher(int[].class), INT_ARRAY);
    }

    private static class BooleanType
    implements IType<Boolean>,
    IContentAssistable {
        private BooleanType() {
        }

        @Override
        public Boolean convert(String value) {
            return Boolean.parseBoolean(value);
        }

        @Override
        public List<Match> getProposals(Match match) {
            return match.propose(String.valueOf(true), String.valueOf(false));
        }
    }

    private static class CharacterType
    implements IType<Character> {
        private CharacterType() {
        }

        @Override
        public Character convert(String value) {
            return Character.valueOf(value.charAt(0));
        }
    }

    private static class FloatType
    implements IType<Float> {
        private FloatType() {
        }

        @Override
        public Float convert(String value) {
            return Float.valueOf(Float.parseFloat(value));
        }
    }

    private static class IntArrayType
    implements IType<int[]> {
        private IntArrayType() {
        }

        @Override
        public int[] convert(String value) {
            String[] intStrings = StringUtils.split((String)value, (char)',');
            int[] ints = new int[intStrings.length];
            int i = 0;
            while (i < ints.length) {
                ints[i] = Integer.parseInt(intStrings[i]);
                ++i;
            }
            return ints;
        }
    }

    private static class IntegerType
    implements IType<Integer> {
        private IntegerType() {
        }

        @Override
        public Integer convert(String value) {
            return Integer.parseInt(value);
        }
    }

    private static class StringArrayType
    implements IType<String[]> {
        private StringArrayType() {
        }

        @Override
        public String[] convert(String value) {
            return StringUtils.split((String)value, (char)';');
        }
    }

    private static class StringType
    implements IType<String> {
        private StringType() {
        }

        @Override
        public String convert(String value) {
            return value;
        }
    }
}

