/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang;

import tcl.lang.ExprValue;
import tcl.lang.Interp;
import tcl.lang.MathFunction;
import tcl.lang.TclException;

class AbsFunction
extends MathFunction {
    AbsFunction() {
        this.argTypes = new int[1];
        this.argTypes[0] = 2;
    }

    @Override
    void apply(Interp interp, ExprValue[] values) throws TclException {
        ExprValue value = values[0];
        if (value.isDoubleType()) {
            double d = value.getDoubleValue();
            if (d > 0.0) {
                value.setDoubleValue(d);
            } else {
                value.setDoubleValue(-d);
            }
        } else {
            long i = value.getIntValue();
            if (i > 0L) {
                value.setIntValue(i);
            } else {
                value.setIntValue(-i);
            }
        }
    }
}

