/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import tcl.lang.Interp;
import tcl.lang.Namespace;
import tcl.lang.Procedure;
import tcl.lang.TclException;
import tcl.lang.TclList;
import tcl.lang.TclObject;
import tcl.lang.TclRuntimeError;
import tcl.lang.Util;
import tcl.lang.Var;

public class CallFrame {
    Interp interp;
    public Namespace ns;
    public boolean isProcCallFrame;
    public TclObject[] objv;
    public CallFrame caller;
    public CallFrame callerVar;
    public int level;
    public HashMap varTable;
    public Var[] compiledLocals;
    public String[] compiledLocalsNames;

    public CallFrame(Interp i) {
        this.interp = i;
        this.ns = i.globalNs;
        this.varTable = null;
        this.compiledLocals = null;
        this.compiledLocalsNames = null;
        this.caller = null;
        this.callerVar = null;
        this.objv = null;
        this.level = 0;
        this.isProcCallFrame = true;
    }

    CallFrame(Interp i, Procedure proc, TclObject[] objv) throws TclException {
        this(i);
        try {
            this.chain(proc, objv);
        }
        catch (TclException e) {
            this.dispose();
            throw e;
        }
    }

    void chain(Procedure proc, TclObject[] objv) throws TclException {
        int startIndex;
        this.ns = proc.wcmd.ns;
        this.objv = objv;
        this.level = this.interp.varFrame == null ? 1 : this.interp.varFrame.level + 1;
        this.caller = this.interp.frame;
        this.callerVar = this.interp.varFrame;
        this.interp.frame = this;
        this.interp.varFrame = this;
        int numArgs = proc.argList.length;
        int n = startIndex = proc.isLambda() ? 2 : 1;
        if (!proc.isVarArgs && objv.length - startIndex > numArgs) {
            this.wrongNumProcArgs(objv, proc);
        }
        int i = 0;
        int j = startIndex;
        while (i < numArgs) {
            TclObject varName = proc.argList[i][0];
            TclObject value = null;
            if (i == numArgs - 1 && proc.isVarArgs) {
                value = TclList.newInstance();
                value.preserve();
                int k = j;
                while (k < objv.length) {
                    TclList.append(this.interp, value, objv[k]);
                    ++k;
                }
                this.interp.setVar(varName, value, 0);
                value.release();
            } else {
                if (j < objv.length) {
                    value = objv[j];
                } else if (proc.argList[i][1] != null) {
                    value = proc.argList[i][1];
                } else {
                    this.wrongNumProcArgs(objv, proc);
                }
                this.interp.setVar(varName, value, 0);
            }
            ++i;
            ++j;
        }
    }

    private String wrongNumProcArgs(TclObject[] objv, Procedure proc) throws TclException {
        StringBuffer sbuf = new StringBuffer(200);
        sbuf.append("wrong # args: should be \"");
        TclObject procNameList = TclList.newInstance();
        if (proc.isLambda()) {
            TclList.append(this.interp, procNameList, objv, 0, 2);
        } else {
            TclList.append(this.interp, procNameList, objv[0]);
        }
        sbuf.append(procNameList.toString());
        int i = 0;
        while (i < proc.argList.length) {
            TclObject arg = proc.argList[i][0];
            TclObject def = proc.argList[i][1];
            sbuf.append(" ");
            if (def != null) {
                sbuf.append("?");
            }
            sbuf.append(arg.toString());
            if (def != null) {
                sbuf.append("?");
            }
            ++i;
        }
        sbuf.append("\"");
        throw new TclException(this.interp, sbuf.toString());
    }

    static boolean exists(Interp interp, String name) {
        Var[] result;
        block3: {
            try {
                result = Var.lookupVar(interp, name, null, 0, "lookup", false, false);
                if (result != null) break block3;
                return false;
            }
            catch (TclException e) {
                throw new TclRuntimeError("unexpected TclException: " + e);
            }
        }
        return !result[0].isVarUndefined();
    }

    ArrayList getVarNames() {
        ArrayList<String> alist = new ArrayList<String>();
        if (this.varTable == null) {
            return alist;
        }
        for (Map.Entry entry : this.varTable.entrySet()) {
            Var v = (Var)entry.getValue();
            if (v.isVarUndefined()) continue;
            alist.add(v.hashKey);
        }
        return alist;
    }

    ArrayList getLocalVarNames() {
        ArrayList<String> alist = new ArrayList<String>();
        if (this.varTable == null) {
            return alist;
        }
        for (Map.Entry entry : this.varTable.entrySet()) {
            Var v = (Var)entry.getValue();
            if (v.isVarUndefined() || v.isVarLink()) continue;
            alist.add(v.hashKey);
        }
        return alist;
    }

    public static int getFrame(Interp interp, String string, CallFrame[] frameArr) throws TclException {
        CallFrame frame;
        int level;
        int curLevel;
        int result = 1;
        int n = curLevel = interp.varFrame == null ? 0 : interp.varFrame.level;
        if (string.length() > 0 && string.charAt(0) == '#') {
            level = (int)Util.getInt(interp, string.substring(1));
            if (level < 0) {
                throw new TclException(interp, "bad level \"" + string + "\"");
            }
        } else if (string.length() > 0 && Character.isDigit(string.charAt(0))) {
            level = (int)Util.getInt(interp, string);
            level = curLevel - level;
        } else {
            level = curLevel - 1;
            result = 0;
        }
        if (level == 0) {
            frame = null;
        } else {
            frame = interp.varFrame;
            while (frame != null) {
                if (frame.level == level) break;
                frame = frame.callerVar;
            }
            if (frame == null) {
                throw new TclException(interp, "bad level \"" + string + "\"");
            }
        }
        frameArr[0] = frame;
        return result;
    }

    public void dispose() {
        this.interp.frame = this.caller;
        this.interp.varFrame = this.callerVar;
        this.caller = null;
        this.callerVar = null;
        if (this.varTable != null) {
            Var.deleteVars(this.interp, this.varTable);
            this.varTable = null;
        }
        if (this.compiledLocals != null) {
            Var.deleteVars(this.interp, this.compiledLocals);
            this.compiledLocals = null;
            this.compiledLocalsNames = null;
        }
    }
}

