/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang;

import java.io.IOException;
import tcl.lang.Interp;
import tcl.lang.TclBoolean;
import tcl.lang.TclEvent;
import tcl.lang.TclException;
import tcl.lang.TclIO;
import tcl.lang.TclObject;
import tcl.lang.TclString;
import tcl.lang.channel.Channel;
import tcl.lang.channel.FileEvent;

public class ConsoleThread
extends Thread {
    Interp interp;
    StringBuffer sbuf;
    private Channel out;
    private Channel err;
    private static final boolean debug = false;

    public ConsoleThread(Interp i) {
        this.setName("ConsoleThread");
        this.interp = i;
        this.sbuf = new StringBuffer(100);
        this.out = TclIO.getStdChannel(1);
        this.err = TclIO.getStdChannel(2);
    }

    @Override
    public synchronized void run() {
        FileEvent.setStdinUsedForCommandInput(true);
        if (this.isInteractive()) {
            this.put(this.out, "% ");
        }
        while (true) {
            this.getLine();
            final String command = this.sbuf.toString();
            TclEvent event = new TclEvent(){

                @Override
                public int processEvent(int flags) {
                    TclObject prompt;
                    if (Interp.commandComplete(command)) {
                        TclObject prompt2;
                        String evalResult;
                        boolean eval_exception;
                        block28: {
                            eval_exception = true;
                            TclObject commandObj = TclString.newInstance(command);
                            try {
                                try {
                                    commandObj.preserve();
                                    ConsoleThread.this.interp.recordAndEval(commandObj, 0);
                                    eval_exception = false;
                                }
                                catch (TclException e) {
                                    ConsoleThread.this.interp.addErrorInfo("");
                                    int code = e.getCompletionCode();
                                    switch (code) {
                                        case 1: {
                                            ConsoleThread.this.putLine(ConsoleThread.this.err, ConsoleThread.this.interp.getResult().toString());
                                            break;
                                        }
                                        case 3: {
                                            ConsoleThread.this.putLine(ConsoleThread.this.err, "invoked \"break\" outside of a loop");
                                            break;
                                        }
                                        case 4: {
                                            ConsoleThread.this.putLine(ConsoleThread.this.err, "invoked \"continue\" outside of a loop");
                                            break;
                                        }
                                        default: {
                                            ConsoleThread.this.putLine(ConsoleThread.this.err, "command returned bad code: " + code);
                                        }
                                    }
                                    commandObj.release();
                                    break block28;
                                }
                            }
                            catch (Throwable throwable) {
                                commandObj.release();
                                throw throwable;
                            }
                            commandObj.release();
                        }
                        if (!eval_exception && (evalResult = ConsoleThread.this.interp.getResult().toString()).length() > 0 && ConsoleThread.this.isInteractive()) {
                            ConsoleThread.this.putLine(ConsoleThread.this.out, evalResult);
                        }
                        ConsoleThread.this.sbuf.setLength(0);
                        try {
                            prompt2 = ConsoleThread.this.interp.getVar("tcl_prompt1", 1);
                        }
                        catch (TclException tclException) {
                            prompt2 = null;
                        }
                        if (prompt2 != null) {
                            try {
                                ConsoleThread.this.interp.eval(prompt2.toString(), 131072);
                            }
                            catch (TclException tclException) {
                                if (ConsoleThread.this.isInteractive()) {
                                    ConsoleThread.this.put(ConsoleThread.this.out, "% ");
                                }
                            }
                        } else if (ConsoleThread.this.isInteractive()) {
                            ConsoleThread.this.put(ConsoleThread.this.out, "% ");
                        }
                        return 1;
                    }
                    try {
                        prompt = ConsoleThread.this.interp.getVar("tcl_prompt2", 1);
                    }
                    catch (TclException tclException) {
                        prompt = null;
                    }
                    if (prompt != null) {
                        try {
                            ConsoleThread.this.interp.eval(prompt.toString(), 131072);
                        }
                        catch (TclException tclException) {
                            if (ConsoleThread.this.isInteractive()) {
                                ConsoleThread.this.put(ConsoleThread.this.out, "");
                            }
                        }
                    } else if (ConsoleThread.this.isInteractive()) {
                        ConsoleThread.this.put(ConsoleThread.this.out, "");
                    }
                    return 1;
                }
            };
            this.interp.getNotifier().queueEvent(event, 0);
            event.sync();
        }
    }

    private void getLine() {
        char c2 = ' ';
        char c = ' ';
        do {
            try {
                int i = System.in.read();
                if (i == -1) {
                    if (this.sbuf.length() == 0) {
                        System.exit(0);
                    } else {
                        return;
                    }
                }
                if ((c = (char)((char)i)) == '\r') {
                    i = System.in.read();
                    if (i == -1) {
                        if (this.sbuf.length() == 0) {
                            System.exit(0);
                        } else {
                            return;
                        }
                    }
                    if ((c2 = (char)((char)i)) == '\n') {
                        c = c2;
                    } else {
                        this.sbuf.append(c);
                        c = c2;
                    }
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                System.exit(0);
            }
            this.sbuf.append(c);
        } while (c != 10);
    }

    private boolean isInteractive() {
        TclObject value = null;
        try {
            value = this.interp.getVar("tcl_interactive", 1);
            return TclBoolean.get(this.interp, value);
        }
        catch (TclException tclException) {
            return true;
        }
    }

    private void putLine(Channel channel, String s) {
        try {
            channel.write(this.interp, s);
            channel.write(this.interp, "\n");
            channel.flush(this.interp);
        }
        catch (IOException ex) {
            System.err.println("IOException in Shell.putLine()");
            ex.printStackTrace(System.err);
        }
        catch (TclException ex) {
            System.err.println("TclException in Shell.putLine()");
            ex.printStackTrace(System.err);
        }
    }

    private void put(Channel channel, String s) {
        try {
            channel.write(this.interp, s);
            channel.flush(this.interp);
        }
        catch (IOException ex) {
            System.err.println("IOException in Shell.put()");
            ex.printStackTrace(System.err);
        }
        catch (TclException ex) {
            System.err.println("TclException in Shell.put()");
            ex.printStackTrace(System.err);
        }
    }
}

